/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basecrdt.core.api;

import com.google.protobuf.ByteString;
import java.util.Arrays;
import lombok.Generated;
import org.apache.bifromq.basecrdt.core.api.AWORSetOperation;
import org.apache.bifromq.basecrdt.core.api.CCounterOperation;
import org.apache.bifromq.basecrdt.core.api.CausalCRDTType;
import org.apache.bifromq.basecrdt.core.api.DWFlagOperation;
import org.apache.bifromq.basecrdt.core.api.EWFlagOperation;
import org.apache.bifromq.basecrdt.core.api.ICRDTOperation;
import org.apache.bifromq.basecrdt.core.api.MVRegOperation;
import org.apache.bifromq.basecrdt.core.api.RWORSetOperation;

public abstract class ORMapOperation
implements ICRDTOperation {
    public final Type type;
    public final ByteString[] keyPath;

    ORMapOperation(Type type, ByteString[] keyPath) {
        this.type = type;
        this.keyPath = keyPath;
    }

    public static ORMapRemover remove(ByteString ... keyPath) {
        return valueType -> new ORMapRemove(Type.RemoveKey, keyPath, valueType);
    }

    public static ORMapUpdater update(final ByteString ... keyPath) {
        return new ORMapUpdater(){

            @Override
            public ORMapUpdate<AWORSetOperation> with(AWORSetOperation op) {
                return new ORMapUpdate<AWORSetOperation>(Type.UpdateKey, keyPath, op);
            }

            @Override
            public ORMapUpdate<RWORSetOperation> with(RWORSetOperation op) {
                return new ORMapUpdate<RWORSetOperation>(Type.UpdateKey, keyPath, op);
            }

            @Override
            public ORMapUpdate<DWFlagOperation> with(DWFlagOperation op) {
                return new ORMapUpdate<DWFlagOperation>(Type.UpdateKey, keyPath, op);
            }

            @Override
            public ORMapUpdate<EWFlagOperation> with(EWFlagOperation op) {
                return new ORMapUpdate<EWFlagOperation>(Type.UpdateKey, keyPath, op);
            }

            @Override
            public ORMapUpdate<MVRegOperation> with(MVRegOperation op) {
                return new ORMapUpdate<MVRegOperation>(Type.UpdateKey, keyPath, op);
            }

            @Override
            public ORMapUpdate<CCounterOperation> with(CCounterOperation op) {
                return new ORMapUpdate<CCounterOperation>(Type.UpdateKey, keyPath, op);
            }

            @Override
            public ORMapUpdate<ORMapOperation> with(ORMapOperation op) {
                return new ORMapUpdate<ORMapOperation>(Type.UpdateKey, keyPath, op);
            }
        };
    }

    @Generated
    public String toString() {
        return "ORMapOperation(type=" + String.valueOf((Object)this.type) + ", keyPath=" + Arrays.deepToString(this.keyPath) + ")";
    }

    public static enum Type {
        UpdateKey,
        RemoveKey,
        Clear;

    }

    public static interface ORMapRemover {
        public ORMapRemove of(CausalCRDTType var1);
    }

    public static class ORMapRemove
    extends ORMapOperation {
        public CausalCRDTType valueType;

        private ORMapRemove(Type type, ByteString[] keyPath, CausalCRDTType valueType) {
            super(type, keyPath);
            this.valueType = valueType;
        }
    }

    public static class ORMapUpdate<T extends ICRDTOperation>
    extends ORMapOperation {
        public final T valueOp;

        private ORMapUpdate(Type type, ByteString[] keyPath, T valueOp) {
            super(type, keyPath);
            this.valueOp = valueOp;
        }
    }

    public static interface ORMapUpdater {
        public ORMapUpdate<AWORSetOperation> with(AWORSetOperation var1);

        public ORMapUpdate<RWORSetOperation> with(RWORSetOperation var1);

        public ORMapUpdate<DWFlagOperation> with(DWFlagOperation var1);

        public ORMapUpdate<EWFlagOperation> with(EWFlagOperation var1);

        public ORMapUpdate<MVRegOperation> with(MVRegOperation var1);

        public ORMapUpdate<CCounterOperation> with(CCounterOperation var1);

        public ORMapUpdate<ORMapOperation> with(ORMapOperation var1);
    }
}

