/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basecrdt.store;

import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public final class PartialMesh {
    public static Set<ByteString> neighbors(SortedSet<ByteString> cluster, ByteString key) {
        return PartialMesh.neighbors(cluster, Collections.emptySet(), key);
    }

    public static Set<ByteString> neighbors(SortedSet<ByteString> cluster, Set<ByteString> ignore, ByteString key) {
        Ring ring = new Ring(cluster);
        TreeSet<ByteString> n = new TreeSet<ByteString>(ByteString.unsignedLexicographicalComparator());
        assert (!ignore.contains(key));
        if (cluster.contains(key)) {
            int index = ring.indexOf(key);
            int offset = 1;
            while (ignore.contains(ring.get(index + offset))) {
                ++offset;
            }
            n.add(ring.get(index + offset));
            offset = 1;
            while (ignore.contains(ring.get(index - offset))) {
                ++offset;
            }
            n.add(ring.get(index - offset));
            int step = PartialMesh.step(cluster.size());
            for (int i = 1; i <= step; ++i) {
                offset = 2 << i - 1;
                while ((ignore.contains(ring.get(index + offset)) || n.contains(ring.get(index + offset))) && ring.get(index + ++offset) != key) {
                }
                n.add(ring.get(index + offset));
                offset = 2 << i - 1;
                while ((ignore.contains(ring.get(index - offset)) || n.contains(ring.get(index - offset))) && ring.get(index - ++offset) != key) {
                }
                n.add(ring.get(index - offset));
            }
        }
        n.remove(key);
        return n;
    }

    static int step(int size) {
        return (int)(Math.log10(size) / Math.log10(20.0));
    }

    private static class Ring {
        private final ArrayList<ByteString> ring;

        Ring(SortedSet keys) {
            this.ring = new ArrayList(keys);
        }

        int indexOf(ByteString key) {
            return this.ring.indexOf(key);
        }

        ByteString get(int i) {
            int idx = (i % this.ring.size() + this.ring.size()) % this.ring.size();
            return this.ring.get(idx);
        }
    }
}

