/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basecluster.memberlist.agent;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.bifromq.basecluster.agent.proto.AgentMemberAddr;
import org.apache.bifromq.basecluster.agent.proto.AgentMemberMetadata;
import org.apache.bifromq.basecrdt.core.api.CRDTURI;
import org.apache.bifromq.basecrdt.core.api.CausalCRDTType;
import org.apache.bifromq.basecrdt.core.api.IMVReg;
import org.apache.bifromq.basecrdt.core.api.IORMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CRDTUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CRDTUtil.class);
    private static final String AGENTKEY_PREFIX = "A";

    static String toAgentURI(String agentId) {
        return CRDTURI.toURI((CausalCRDTType)CausalCRDTType.ormap, (String)AGENTKEY_PREFIX.concat(agentId));
    }

    static Map<AgentMemberAddr, AgentMemberMetadata> toAgentMemberMap(IORMap agentCRDT) {
        HashMap<AgentMemberAddr, AgentMemberMetadata> agentMemberMap = new HashMap<AgentMemberAddr, AgentMemberMetadata>();
        Iterator orMapKeyItr = agentCRDT.keys();
        while (orMapKeyItr.hasNext()) {
            IORMap.ORMapKey orMapKey = (IORMap.ORMapKey)orMapKeyItr.next();
            Optional<AgentMemberMetadata> meta = CRDTUtil.parseMetadata(agentCRDT.getMVReg(new ByteString[]{orMapKey.key()}));
            meta.ifPresent(m -> agentMemberMap.put(CRDTUtil.parseAgentMemberAddr(orMapKey), (AgentMemberMetadata)m));
        }
        return agentMemberMap;
    }

    static Optional<AgentMemberMetadata> getAgentMemberMetadata(IORMap agentCRDT, AgentMemberAddr addr) {
        return CRDTUtil.parseMetadata(agentCRDT.getMVReg(new ByteString[]{addr.toByteString()}));
    }

    private static AgentMemberAddr parseAgentMemberAddr(IORMap.ORMapKey key) {
        assert (key.valueType() == CausalCRDTType.mvreg);
        return AgentMemberAddr.parseFrom(key.key());
    }

    private static Optional<AgentMemberMetadata> parseMetadata(IMVReg value) {
        ArrayList metaList = Lists.newArrayList((Iterator)Iterators.filter((Iterator)Iterators.transform((Iterator)value.read(), data -> {
            try {
                return AgentMemberMetadata.parseFrom(data);
            }
            catch (InvalidProtocolBufferException e) {
                log.error("Unable to parse agent host node", (Throwable)e);
                return null;
            }
        }), Objects::nonNull));
        metaList.sort(Comparator.comparingLong(AgentMemberMetadata::getHlc).reversed());
        return Optional.ofNullable(metaList.isEmpty() ? null : (AgentMemberMetadata)metaList.get(0));
    }

    @Generated
    private CRDTUtil() {
    }
}

