/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.mqtt.inbox;

import java.util.HashSet;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import org.apache.bifromq.base.util.CompletableFutureUtil;
import org.apache.bifromq.baserpc.client.IRPCClient;
import org.apache.bifromq.baserpc.client.exception.ServerNotFoundException;
import org.apache.bifromq.mqtt.inbox.rpc.proto.WriteReply;
import org.apache.bifromq.mqtt.inbox.rpc.proto.WriteRequest;
import org.apache.bifromq.plugin.subbroker.DeliveryPack;
import org.apache.bifromq.plugin.subbroker.DeliveryPackage;
import org.apache.bifromq.plugin.subbroker.DeliveryReply;
import org.apache.bifromq.plugin.subbroker.DeliveryRequest;
import org.apache.bifromq.plugin.subbroker.DeliveryResult;
import org.apache.bifromq.plugin.subbroker.DeliveryResults;
import org.apache.bifromq.plugin.subbroker.IDeliverer;
import org.apache.bifromq.type.MatchInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DeliveryPipeline
implements IDeliverer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeliveryPipeline.class);
    private final IRPCClient.IRequestPipeline<WriteRequest, WriteReply> ppln;

    DeliveryPipeline(IRPCClient.IRequestPipeline<WriteRequest, WriteReply> ppln) {
        this.ppln = ppln;
    }

    public CompletableFuture<DeliveryReply> deliver(DeliveryRequest request) {
        long reqId = System.nanoTime();
        return ((CompletableFuture)this.ppln.invoke((Object)WriteRequest.newBuilder().setReqId(reqId).setRequest(request).build()).thenApply(WriteReply::getReply)).exceptionally(CompletableFutureUtil.unwrap(e -> {
            if (e instanceof ServerNotFoundException) {
                DeliveryReply.Builder replyBuilder = DeliveryReply.newBuilder().setCode(DeliveryReply.Code.OK);
                for (String tenantId : request.getPackageMap().keySet()) {
                    HashSet tenantMatchInfos = new HashSet();
                    DeliveryResults.Builder resultsBuilder = DeliveryResults.newBuilder();
                    DeliveryPackage deliveryPackage = (DeliveryPackage)request.getPackageMap().get(tenantId);
                    for (DeliveryPack pack : deliveryPackage.getPackList()) {
                        tenantMatchInfos.addAll(pack.getMatchInfoList());
                    }
                    for (MatchInfo matchInfo : tenantMatchInfos) {
                        resultsBuilder.addResult(DeliveryResult.newBuilder().setMatchInfo(matchInfo).setCode(DeliveryResult.Code.NO_RECEIVER).build());
                    }
                    replyBuilder.putResult(tenantId, resultsBuilder.build());
                }
                return replyBuilder.build();
            }
            log.debug("Failed to deliver request: {}", (Object)request, e);
            return DeliveryReply.newBuilder().setCode(DeliveryReply.Code.ERROR).build();
        }));
    }

    public void close() {
        this.ppln.close();
    }
}

