/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.metrics;

import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tags;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.ToDoubleFunction;
import org.apache.bifromq.metrics.TenantMetric;

class TenantFunctionCounters {
    private static final ConcurrentMap<String, Map<TenantMetricKey, FunctionCounter>> TENANT_FUNCTION_COUNTERS = new ConcurrentHashMap<String, Map<TenantMetricKey, FunctionCounter>>();

    TenantFunctionCounters() {
    }

    static <C> void counting(String tenantId, TenantMetric counterMetric, C ctr, ToDoubleFunction<C> supplier, String ... tagValuePair) {
        assert (counterMetric.meterType == Meter.Type.COUNTER && counterMetric.isFunction);
        TENANT_FUNCTION_COUNTERS.compute(tenantId, (k, v) -> {
            if (v == null) {
                v = new HashMap<TenantMetricKey, FunctionCounter>();
            }
            Tags tags = Tags.of((String[])tagValuePair);
            v.computeIfAbsent(new TenantMetricKey(counterMetric, tags), tenantMetricKey -> FunctionCounter.builder((String)counterMetric.metricName, (Object)ctr, (ToDoubleFunction)supplier).tags((Iterable)tags.and("tenantId", tenantId)).register((MeterRegistry)Metrics.globalRegistry));
            return v;
        });
    }

    static void stopCounting(String tenantId, TenantMetric counterMetric, String ... tagValuePair) {
        assert (counterMetric.meterType == Meter.Type.COUNTER && counterMetric.isFunction);
        TENANT_FUNCTION_COUNTERS.computeIfPresent(tenantId, (k, ctrMap) -> {
            Tags tags = Tags.of((String[])tagValuePair);
            FunctionCounter functionCounter = (FunctionCounter)ctrMap.remove(new TenantMetricKey(counterMetric, tags));
            if (functionCounter != null) {
                Metrics.globalRegistry.remove((Meter)functionCounter);
            }
            if (ctrMap.isEmpty()) {
                return null;
            }
            return ctrMap;
        });
    }

    private record TenantMetricKey(TenantMetric counterMetrics, Tags tags) {
    }
}

