/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.raft;

import org.apache.bifromq.basekv.raft.IRaftStateStore;
import org.apache.bifromq.basekv.raft.PeerLogReplicatorState;
import org.apache.bifromq.basekv.raft.PeerLogReplicatorStateProbing;
import org.apache.bifromq.basekv.raft.PeerLogReplicatorStateReplicating;
import org.apache.bifromq.basekv.raft.RaftConfig;
import org.apache.bifromq.basekv.raft.proto.RaftNodeSyncState;
import org.slf4j.Logger;

class PeerLogReplicatorStateSnapshotSyncing
extends PeerLogReplicatorState {
    private int heartbeatElapsedTick;
    private int installSnapshotElapsedTick;
    private boolean needHeartbeat;
    private boolean snapshotSent;

    PeerLogReplicatorStateSnapshotSyncing(String peerId, RaftConfig config, IRaftStateStore stateStorage, Logger logger) {
        super(peerId, config, stateStorage, stateStorage.latestSnapshot().getIndex(), stateStorage.latestSnapshot().getIndex() + 1L, logger);
    }

    @Override
    public RaftNodeSyncState state() {
        return RaftNodeSyncState.SnapshotSyncing;
    }

    @Override
    public PeerLogReplicatorState tick() {
        ++this.installSnapshotElapsedTick;
        if (this.installSnapshotElapsedTick >= this.config.getInstallSnapshotTimeoutTick()) {
            this.logger.debug("Peer[{}] install snapshot timeout from tracker[matchIndex:{},nextIndex:{},state:{}], probing again", new Object[]{this.peerId, this.matchIndex, this.nextIndex, this.state()});
            return new PeerLogReplicatorStateProbing(this.peerId, this.config, this.stateStorage, this.logger);
        }
        if (this.heartbeatElapsedTick >= this.config.getHeartbeatTimeoutTick()) {
            this.heartbeatElapsedTick = 0;
            this.needHeartbeat = true;
        }
        ++this.heartbeatElapsedTick;
        return this;
    }

    @Override
    public long catchupRate() {
        return 0L;
    }

    @Override
    public boolean pauseReplicating() {
        return this.snapshotSent;
    }

    @Override
    public boolean needHeartbeat() {
        return this.needHeartbeat;
    }

    @Override
    public PeerLogReplicatorState backoff(long peerRejectedIndex, long peerLastIndex) {
        if (this.matchIndex == peerLastIndex) {
            this.logger.debug("Peer[{}] rejected snapshot from tracker[matchIndex:{},nextIndex:{},state:{}], try again", new Object[]{this.peerId, this.matchIndex, this.nextIndex, this.state()});
            return new PeerLogReplicatorStateSnapshotSyncing(this.peerId, this.config, this.stateStorage, this.logger);
        }
        return this;
    }

    @Override
    public PeerLogReplicatorState confirmMatch(long peerLastIndex) {
        if (this.matchIndex == peerLastIndex) {
            if (this.stateStorage.latestSnapshot().getIndex() == this.matchIndex) {
                this.logger.debug("Peer[{}] installed snapshot from tracker[matchIndex:{},nextIndex:{},state:{}], start replicating", new Object[]{this.peerId, this.matchIndex, this.nextIndex, this.state()});
                return new PeerLogReplicatorStateReplicating(this.peerId, this.config, this.stateStorage, this.matchIndex, this.nextIndex, this.logger);
            }
            this.logger.debug("Peer[{}] installed old snapshot from tracker[matchIndex:{},nextIndex:{},state:{}], try again", new Object[]{this.peerId, this.matchIndex, this.nextIndex, this.state()});
            return new PeerLogReplicatorStateSnapshotSyncing(this.peerId, this.config, this.stateStorage, this.logger);
        }
        return this;
    }

    @Override
    public PeerLogReplicatorState replicateTo(long endIndex) {
        if (endIndex != this.matchIndex) {
            return new PeerLogReplicatorStateSnapshotSyncing(this.peerId, this.config, this.stateStorage, this.logger);
        }
        this.snapshotSent = true;
        this.needHeartbeat = false;
        return this;
    }
}

