/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.plugin.settingprovider;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.github.benmanes.caffeine.cache.Scheduler;
import java.util.EnumMap;
import org.apache.bifromq.plugin.settingprovider.CacheOptions;
import org.apache.bifromq.plugin.settingprovider.ISettingProvider;
import org.apache.bifromq.plugin.settingprovider.Setting;
import org.checkerframework.checker.nullness.qual.Nullable;

public class CacheableSettingProvider
implements ISettingProvider {
    private final EnumMap<Setting, LoadingCache<String, Object>> settingCache = new EnumMap(Setting.class);
    private final ISettingProvider delegate;

    public CacheableSettingProvider(ISettingProvider delegate, CacheOptions options) {
        this.delegate = delegate;
        for (Setting setting : Setting.values()) {
            this.settingCache.put(setting, (LoadingCache<String, Object>)Caffeine.newBuilder().expireAfterAccess(options.expireDuration()).maximumSize((long)options.maxCachedTenants()).refreshAfterWrite(options.refreshDuration()).scheduler(Scheduler.systemScheduler()).build(this.buildCacheLoader(setting, options.provideInitValue())));
        }
    }

    public <R> R provide(Setting setting, String tenantId) {
        return (R)this.settingCache.get(setting).get((Object)tenantId);
    }

    public void close() {
        this.delegate.close();
    }

    private CacheLoader<String, Object> buildCacheLoader(final Setting setting, boolean provideInitValue) {
        if (provideInitValue) {
            return new CacheLoader<String, Object>(){

                public @Nullable Object load(String tenantId) {
                    Object val = CacheableSettingProvider.this.delegate.provide(setting, tenantId);
                    return val == null ? setting.initialValue() : val;
                }

                public @Nullable Object reload(String tenantId, Object oldValue) {
                    Object val = CacheableSettingProvider.this.delegate.provide(setting, tenantId);
                    return val == null ? oldValue : val;
                }
            };
        }
        return new CacheLoader<String, Object>(){

            public @Nullable Object load(String tenantId) {
                return setting.initialValue();
            }

            public @Nullable Object reload(String tenantId, Object oldValue) {
                Object val = CacheableSettingProvider.this.delegate.provide(setting, tenantId);
                return val == null ? oldValue : val;
            }
        };
    }
}

