/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.client.scheduler;

import org.apache.bifromq.basekv.client.IBaseKVStoreClient;
import org.apache.bifromq.basekv.client.IQueryPipeline;
import org.apache.bifromq.basekv.client.scheduler.BatchQueryCall;
import org.apache.bifromq.basekv.client.scheduler.IBatchQueryCallBuilder;
import org.apache.bifromq.basekv.client.scheduler.QueryCallBatcherKey;
import org.apache.bifromq.basescheduler.IBatchCall;
import org.apache.bifromq.basescheduler.IBatchCallBuilder;
import org.apache.bifromq.basescheduler.IBatchCallBuilderFactory;

final class BatchQueryCallBuilderFactory<ReqT, RespT, BatchCallT extends BatchQueryCall<ReqT, RespT>>
implements IBatchCallBuilderFactory<ReqT, RespT, QueryCallBatcherKey> {
    private final IBaseKVStoreClient storeClient;
    private final IBatchQueryCallBuilder<ReqT, RespT, BatchCallT> batchCallBuilder;

    BatchQueryCallBuilderFactory(IBaseKVStoreClient storeClient, IBatchQueryCallBuilder<ReqT, RespT, BatchCallT> batchBuilder) {
        this.storeClient = storeClient;
        this.batchCallBuilder = batchBuilder;
    }

    public IBatchCallBuilder<ReqT, RespT, QueryCallBatcherKey> newBuilder(String name, final QueryCallBatcherKey batcherKey) {
        final IQueryPipeline storePipeline = batcherKey.linearizable ? this.storeClient.createLinearizedQueryPipeline(batcherKey.storeId) : this.storeClient.createQueryPipeline(batcherKey.storeId);
        return new IBatchCallBuilder<ReqT, RespT, QueryCallBatcherKey>(){

            public IBatchCall<ReqT, RespT, QueryCallBatcherKey> newBatchCall() {
                return BatchQueryCallBuilderFactory.this.batchCallBuilder.newBatchCall(storePipeline, batcherKey);
            }

            public void close() {
                storePipeline.close();
            }
        };
    }
}

