/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.store.range;

import com.google.protobuf.ByteString;
import java.util.Optional;
import org.apache.bifromq.basekv.proto.Boundary;
import org.apache.bifromq.basekv.proto.State;
import org.apache.bifromq.basekv.raft.proto.ClusterConfig;
import org.apache.bifromq.basekv.store.api.IKVIterator;
import org.apache.bifromq.basekv.store.api.IKVRangeRefreshableReader;
import org.apache.bifromq.basekv.store.range.IKVLoadRecorder;
import org.apache.bifromq.basekv.store.range.LoadRecordableKVIterator;

class LoadRecordableKVReader
implements IKVRangeRefreshableReader {
    private final IKVRangeRefreshableReader delegate;
    private final IKVLoadRecorder recorder;

    LoadRecordableKVReader(IKVRangeRefreshableReader delegate, IKVLoadRecorder recorder) {
        this.delegate = delegate;
        this.recorder = recorder;
    }

    public long version() {
        return this.delegate.version();
    }

    public State state() {
        return this.delegate.state();
    }

    public long lastAppliedIndex() {
        return this.delegate.lastAppliedIndex();
    }

    public Boundary boundary() {
        return this.delegate.boundary();
    }

    public ClusterConfig clusterConfig() {
        return this.delegate.clusterConfig();
    }

    public long size(Boundary boundary) {
        return this.delegate.size(boundary);
    }

    public boolean exist(ByteString key) {
        long start = System.nanoTime();
        boolean result = this.delegate.exist(key);
        this.recorder.record(key, System.nanoTime() - start);
        return result;
    }

    public Optional<ByteString> get(ByteString key) {
        long start = System.nanoTime();
        Optional result = this.delegate.get(key);
        this.recorder.record(key, System.nanoTime() - start);
        return result;
    }

    public IKVIterator iterator() {
        return new LoadRecordableKVIterator(this.delegate.iterator(), this.recorder);
    }

    public IKVIterator iterator(Boundary boundary) {
        return new LoadRecordableKVIterator(this.delegate.iterator(boundary), this.recorder);
    }

    public void close() {
        this.delegate.close();
    }

    public void refresh() {
        long start = System.nanoTime();
        this.delegate.refresh();
        this.recorder.record(System.nanoTime() - start);
    }
}

