/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum Distribution {
    RANDOM("Random"),
    BY_LOG_STREAM("ByLogStream"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Distribution> VALUE_MAP;
    private final String value;

    private Distribution(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Distribution fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Distribution> knownValues() {
        EnumSet<Distribution> knownValues = EnumSet.allOf(Distribution.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(Distribution.class, Distribution::toString);
    }
}

