/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.amazon.common.runtime;

import io.quarkiverse.amazon.common.runtime.AsyncHttpClientConfig;
import io.quarkiverse.amazon.common.runtime.FileStoreTlsManagersProviderConfig;
import io.quarkiverse.amazon.common.runtime.RuntimeConfigurationError;
import io.quarkiverse.amazon.common.runtime.SyncHttpClientConfig;
import io.quarkiverse.amazon.common.runtime.TlsKeyManagersProviderConfig;
import io.quarkiverse.amazon.common.runtime.TlsKeyManagersProviderType;
import io.quarkiverse.amazon.common.runtime.TlsTrustManagersProviderConfig;
import io.quarkiverse.amazon.common.runtime.TlsTrustManagersProviderType;
import io.quarkus.runtime.RuntimeValue;
import java.net.URI;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.TlsKeyManagersProvider;
import software.amazon.awssdk.http.TlsTrustManagersProvider;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import software.amazon.awssdk.utils.StringUtils;

public abstract class AbstractAmazonClientTransportRecorder {
    public RuntimeValue<SdkHttpClient.Builder> configureSync(String clientName, RuntimeValue<SyncHttpClientConfig> syncConfigRuntime) {
        throw new IllegalStateException("Configuring a sync client is not supported by " + this.getClass().getName());
    }

    public RuntimeValue<SdkAsyncHttpClient.Builder> configureAsync(String clientName, RuntimeValue<AsyncHttpClientConfig> asyncConfigRuntime) {
        throw new IllegalStateException("Configuring an async client is not supported by " + this.getClass().getName());
    }

    protected TlsKeyManagersProvider getTlsKeyManagersProvider(TlsKeyManagersProviderConfig config) {
        return config.type().create(config);
    }

    protected TlsTrustManagersProvider getTlsTrustManagersProvider(TlsTrustManagersProviderConfig config) {
        return config.type().create(config);
    }

    protected void validateProxyEndpoint(String extension, URI endpoint, String clientType) {
        if (StringUtils.isBlank((CharSequence)endpoint.getScheme())) {
            throw new RuntimeConfigurationError(String.format("quarkus.%s.%s-client.proxy.endpoint (%s) - scheme must be specified", extension, clientType, endpoint.toString()));
        }
        if (StringUtils.isBlank((CharSequence)endpoint.getHost())) {
            throw new RuntimeConfigurationError(String.format("quarkus.%s.%s-client.proxy.endpoint (%s) - host must be specified", extension, clientType, endpoint.toString()));
        }
        if (StringUtils.isNotBlank((CharSequence)endpoint.getUserInfo())) {
            throw new RuntimeConfigurationError(String.format("quarkus.%s.%s-client.proxy.endpoint (%s) - user info is not supported.", extension, clientType, endpoint.toString()));
        }
        if (StringUtils.isNotBlank((CharSequence)endpoint.getPath())) {
            throw new RuntimeConfigurationError(String.format("quarkus.%s.%s-client.proxy.endpoint (%s) - path is not supported.", extension, clientType, endpoint.toString()));
        }
        if (StringUtils.isNotBlank((CharSequence)endpoint.getQuery())) {
            throw new RuntimeConfigurationError(String.format("quarkus.%s.%s-client.proxy.endpoint (%s) - query is not supported.", extension, clientType, endpoint.toString()));
        }
        if (StringUtils.isNotBlank((CharSequence)endpoint.getFragment())) {
            throw new RuntimeConfigurationError(String.format("quarkus.%s.%s-client.proxy.endpoint (%s) - fragment is not supported.", extension, clientType, endpoint.toString()));
        }
    }

    protected void validateTlsKeyManagersProvider(String extension, TlsKeyManagersProviderConfig config, String clientType) {
        if (config != null && config.type() == TlsKeyManagersProviderType.FILE_STORE) {
            this.validateFileStore(extension, clientType, "key", config.fileStore());
        }
    }

    protected void validateTlsTrustManagersProvider(String extension, TlsTrustManagersProviderConfig config, String clientType) {
        if (config != null && config.type() == TlsTrustManagersProviderType.FILE_STORE) {
            this.validateFileStore(extension, clientType, "trust", config.fileStore());
        }
    }

    protected void validateFileStore(String extension, String clientType, String storeType, FileStoreTlsManagersProviderConfig fileStore) {
        if (fileStore == null) {
            throw new RuntimeConfigurationError(String.format("quarkus.%s.%s-client.tls-%s-managers-provider.file-store must be specified if 'FILE_STORE' provider type is used", extension, clientType, storeType));
        }
        if (!fileStore.path().isPresent()) {
            throw new RuntimeConfigurationError(String.format("quarkus.%s.%s-client.tls-%s-managers-provider.file-store.path should not be empty if 'FILE_STORE' provider is used.", extension, clientType, storeType));
        }
        if (!fileStore.type().isPresent()) {
            throw new RuntimeConfigurationError(String.format("quarkus.%s.%s-client.tls-%s-managers-provider.file-store.type should not be empty if 'FILE_STORE' provider is used.", extension, clientType, storeType));
        }
        if (!fileStore.password().isPresent()) {
            throw new RuntimeConfigurationError(String.format("quarkus.%s.%s-client.tls-%s-managers-provider.file-store.password should not be empty if 'FILE_STORE' provider is used.", extension, clientType, storeType));
        }
    }
}

