/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.schema.table;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public enum TableNodeStatus {
    PRE_CREATE(0),
    USING(1),
    PRE_DELETE(2);

    private final byte status;

    private TableNodeStatus(byte status) {
        this.status = status;
    }

    public void serialize(OutputStream outputStream) throws IOException {
        ReadWriteIOUtils.write((byte)this.status, (OutputStream)outputStream);
    }

    public static TableNodeStatus deserialize(InputStream inputStream) throws IOException {
        switch (ReadWriteIOUtils.readByte((InputStream)inputStream)) {
            case 0: {
                return PRE_CREATE;
            }
            case 1: {
                return USING;
            }
            case 2: {
                return PRE_DELETE;
            }
        }
        throw new IllegalArgumentException();
    }

    public static TableNodeStatus deserialize(ByteBuffer buffer) {
        switch (ReadWriteIOUtils.readByte((ByteBuffer)buffer)) {
            case 0: {
                return PRE_CREATE;
            }
            case 1: {
                return USING;
            }
            case 2: {
                return PRE_DELETE;
            }
        }
        throw new IllegalArgumentException();
    }
}

