/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import java.util.Arrays;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.enumerated.StructureType;
import org.eclipse.milo.opcua.stack.core.types.structured.DataTypeDefinition;
import org.eclipse.milo.opcua.stack.core.types.structured.StructureField;

public class StructureDefinition
extends DataTypeDefinition
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=99");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=122");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=14798");
    public static final ExpandedNodeId JSON_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=15066");
    private final NodeId defaultEncodingId;
    private final NodeId baseDataType;
    private final StructureType structureType;
    private final StructureField[] fields;

    public StructureDefinition(NodeId defaultEncodingId, NodeId baseDataType, StructureType structureType, StructureField[] fields) {
        this.defaultEncodingId = defaultEncodingId;
        this.baseDataType = baseDataType;
        this.structureType = structureType;
        this.fields = fields;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    public NodeId getDefaultEncodingId() {
        return this.defaultEncodingId;
    }

    public NodeId getBaseDataType() {
        return this.baseDataType;
    }

    public StructureType getStructureType() {
        return this.structureType;
    }

    public StructureField[] getFields() {
        return this.fields;
    }

    protected StructureDefinition(StructureDefinitionBuilder<?, ?> b) {
        super((DataTypeDefinition.DataTypeDefinitionBuilder<?, ?>)b);
        this.defaultEncodingId = ((StructureDefinitionBuilder)b).defaultEncodingId;
        this.baseDataType = ((StructureDefinitionBuilder)b).baseDataType;
        this.structureType = ((StructureDefinitionBuilder)b).structureType;
        this.fields = ((StructureDefinitionBuilder)b).fields;
    }

    public static StructureDefinitionBuilder<?, ?> builder() {
        return new StructureDefinitionBuilderImpl();
    }

    public StructureDefinitionBuilder<?, ?> toBuilder() {
        return new StructureDefinitionBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StructureDefinition)) {
            return false;
        }
        StructureDefinition other = (StructureDefinition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NodeId this$defaultEncodingId = this.getDefaultEncodingId();
        NodeId other$defaultEncodingId = other.getDefaultEncodingId();
        if (this$defaultEncodingId == null ? other$defaultEncodingId != null : !((Object)this$defaultEncodingId).equals(other$defaultEncodingId)) {
            return false;
        }
        NodeId this$baseDataType = this.getBaseDataType();
        NodeId other$baseDataType = other.getBaseDataType();
        if (this$baseDataType == null ? other$baseDataType != null : !((Object)this$baseDataType).equals(other$baseDataType)) {
            return false;
        }
        StructureType this$structureType = this.getStructureType();
        StructureType other$structureType = other.getStructureType();
        if (this$structureType == null ? other$structureType != null : !this$structureType.equals(other$structureType)) {
            return false;
        }
        return Arrays.deepEquals(this.getFields(), other.getFields());
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof StructureDefinition;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        NodeId $defaultEncodingId = this.getDefaultEncodingId();
        result = result * 59 + ($defaultEncodingId == null ? 43 : ((Object)$defaultEncodingId).hashCode());
        NodeId $baseDataType = this.getBaseDataType();
        result = result * 59 + ($baseDataType == null ? 43 : ((Object)$baseDataType).hashCode());
        StructureType $structureType = this.getStructureType();
        result = result * 59 + ($structureType == null ? 43 : $structureType.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getFields());
        return result;
    }

    @Override
    public String toString() {
        return "StructureDefinition(defaultEncodingId=" + this.getDefaultEncodingId() + ", baseDataType=" + this.getBaseDataType() + ", structureType=" + this.getStructureType() + ", fields=" + Arrays.deepToString(this.getFields()) + ")";
    }

    private static final class StructureDefinitionBuilderImpl
    extends StructureDefinitionBuilder<StructureDefinition, StructureDefinitionBuilderImpl> {
        private StructureDefinitionBuilderImpl() {
        }

        @Override
        protected StructureDefinitionBuilderImpl self() {
            return this;
        }

        @Override
        public StructureDefinition build() {
            return new StructureDefinition(this);
        }
    }

    public static abstract class StructureDefinitionBuilder<C extends StructureDefinition, B extends StructureDefinitionBuilder<C, B>>
    extends DataTypeDefinition.DataTypeDefinitionBuilder<C, B> {
        private NodeId defaultEncodingId;
        private NodeId baseDataType;
        private StructureType structureType;
        private StructureField[] fields;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            StructureDefinitionBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(StructureDefinition instance, StructureDefinitionBuilder<?, ?> b) {
            b.defaultEncodingId(instance.defaultEncodingId);
            b.baseDataType(instance.baseDataType);
            b.structureType(instance.structureType);
            b.fields(instance.fields);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B defaultEncodingId(NodeId defaultEncodingId) {
            this.defaultEncodingId = defaultEncodingId;
            return (B)this.self();
        }

        public B baseDataType(NodeId baseDataType) {
            this.baseDataType = baseDataType;
            return (B)this.self();
        }

        public B structureType(StructureType structureType) {
            this.structureType = structureType;
            return (B)this.self();
        }

        public B fields(StructureField[] fields) {
            this.fields = fields;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "StructureDefinition.StructureDefinitionBuilder(super=" + super.toString() + ", defaultEncodingId=" + this.defaultEncodingId + ", baseDataType=" + this.baseDataType + ", structureType=" + this.structureType + ", fields=" + Arrays.deepToString(this.fields) + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<StructureDefinition> {
        @Override
        public Class<StructureDefinition> getType() {
            return StructureDefinition.class;
        }

        @Override
        public StructureDefinition decode(SerializationContext context, UaDecoder decoder) {
            NodeId defaultEncodingId = decoder.readNodeId("DefaultEncodingId");
            NodeId baseDataType = decoder.readNodeId("BaseDataType");
            StructureType structureType = StructureType.from(decoder.readInt32("StructureType"));
            StructureField[] fields = (StructureField[])decoder.readStructArray("Fields", StructureField.TYPE_ID);
            return new StructureDefinition(defaultEncodingId, baseDataType, structureType, fields);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, StructureDefinition value) {
            encoder.writeNodeId("DefaultEncodingId", value.getDefaultEncodingId());
            encoder.writeNodeId("BaseDataType", value.getBaseDataType());
            encoder.writeInt32("StructureType", value.getStructureType().getValue());
            encoder.writeStructArray("Fields", (Object[])value.getFields(), StructureField.TYPE_ID);
        }
    }
}

