/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.source;

import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeTaskMeta;
import org.apache.iotdb.commons.pipe.config.plugin.env.PipeTaskSourceRuntimeEnvironment;
import org.apache.iotdb.commons.pipe.datastructure.options.PipeInclusionOptions;
import org.apache.iotdb.commons.pipe.datastructure.pattern.TablePattern;
import org.apache.iotdb.commons.pipe.datastructure.pattern.TreePattern;
import org.apache.iotdb.pipe.api.PipeExtractor;
import org.apache.iotdb.pipe.api.annotation.TableModel;
import org.apache.iotdb.pipe.api.annotation.TreeModel;
import org.apache.iotdb.pipe.api.customizer.configuration.PipeExtractorRuntimeConfiguration;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameterValidator;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.iotdb.pipe.api.exception.PipeParameterNotValidException;

@TreeModel
@TableModel
public abstract class IoTDBSource
implements PipeExtractor {
    protected String taskID;
    protected String pipeName;
    protected long creationTime;
    protected int regionId;
    protected PipeTaskMeta pipeTaskMeta;
    protected boolean isForwardingPipeRequests = true;
    protected final AtomicBoolean hasBeenStarted = new AtomicBoolean(false);
    protected String userName;
    protected boolean skipIfNoPrivileges = true;

    public void validate(PipeParameterValidator validator) throws Exception {
        String inclusionString = PipeInclusionOptions.getInclusionString(validator.getParameters());
        String exclusionString = PipeInclusionOptions.getExclusionString(validator.getParameters());
        boolean isTreeDataListened = TreePattern.isTreeModelDataAllowToBeCaptured(validator.getParameters());
        boolean isTableDataListened = TablePattern.isTableModelDataAllowToBeCaptured(validator.getParameters());
        validator.validate(args -> PipeInclusionOptions.optionsAreAllLegal((String)args, isTreeDataListened, isTableDataListened), "The 'inclusion' string contains illegal path.", (Object)inclusionString).validate(args -> PipeInclusionOptions.optionsAreAllLegal((String)args, isTreeDataListened, isTableDataListened), "The 'inclusion.exclusion' string contains illegal path.", (Object)exclusionString).validate(args -> PipeInclusionOptions.hasAtLeastOneOption((String)args[0], (String)args[1], isTreeDataListened, isTableDataListened), "The pipe inclusion content can't be empty.", new Object[]{inclusionString, exclusionString});
        validator.validateSynonymAttributes(Arrays.asList("extractor.user", "source.user"), Arrays.asList("extractor.username", "source.username"), false);
        this.validateDoubleLiving(validator.getParameters());
    }

    private void validateDoubleLiving(PipeParameters parameters) {
        boolean isDoubleLiving = parameters.getBooleanOrDefault(Arrays.asList("extractor.mode.double-living", "source.mode.double-living"), false);
        if (!isDoubleLiving) {
            return;
        }
        Boolean isCaptureTree = parameters.getBooleanByKeys(new String[]{"extractor.capture.tree", "source.capture.tree"});
        if (Objects.nonNull(isCaptureTree) && !isCaptureTree.booleanValue()) {
            throw new PipeParameterNotValidException("capture.tree can not be specified to false when double living is enabled");
        }
        Boolean isCaptureTable = parameters.getBooleanByKeys(new String[]{"extractor.capture.table", "source.capture.table"});
        if (Objects.nonNull(isCaptureTable) && !isCaptureTable.booleanValue()) {
            throw new PipeParameterNotValidException("capture.table can not be specified to false when double living is enabled");
        }
        Boolean isForwardingPipeRequests = parameters.getBooleanByKeys(new String[]{"extractor.forwarding-pipe-requests", "source.forwarding-pipe-requests"});
        if (Objects.nonNull(isForwardingPipeRequests) && isForwardingPipeRequests.booleanValue()) {
            throw new PipeParameterNotValidException("forwarding-pipe-requests can not be specified to true when double living is enabled");
        }
    }

    public void customize(PipeParameters parameters, PipeExtractorRuntimeConfiguration configuration) throws Exception {
        PipeTaskSourceRuntimeEnvironment environment = (PipeTaskSourceRuntimeEnvironment)configuration.getRuntimeEnvironment();
        this.regionId = environment.getRegionId();
        this.pipeName = environment.getPipeName();
        this.creationTime = environment.getCreationTime();
        this.taskID = this.pipeName + "_" + this.regionId + "_" + this.creationTime;
        this.pipeTaskMeta = environment.getPipeTaskMeta();
        this.isForwardingPipeRequests = true;
        this.userName = parameters.getStringByKeys(new String[]{"extractor.user", "source.user", "extractor.username", "source.username"});
        this.skipIfNoPrivileges = IoTDBSource.getSkipIfNoPrivileges(parameters);
    }

    public static boolean getSkipIfNoPrivileges(PipeParameters extractorParameters) {
        String extractorSkipIfValue = extractorParameters.getStringOrDefault(Arrays.asList("extractor.skipif", "source.skipif"), "no-privileges").trim();
        Set skipIfOptionSet = Arrays.stream(extractorSkipIfValue.split(",")).map(String::trim).filter(s -> !s.isEmpty()).map(String::toLowerCase).collect(Collectors.toSet());
        boolean skipIfNoPrivileges = skipIfOptionSet.remove("no-privileges");
        if (!skipIfOptionSet.isEmpty()) {
            throw new PipeParameterNotValidException(String.format("Parameters in set %s are not allowed in 'skipif'", skipIfOptionSet));
        }
        return skipIfNoPrivileges;
    }

    public void start() throws Exception {
        if (this.hasBeenStarted.get()) {
            return;
        }
        this.hasBeenStarted.set(true);
    }

    public String getTaskID() {
        return this.taskID;
    }

    public String getPipeName() {
        return this.pipeName;
    }

    public int getRegionId() {
        return this.regionId;
    }

    public long getCreationTime() {
        return this.creationTime;
    }
}

