/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.schema.view.viewExpression.binary;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import org.apache.iotdb.commons.schema.view.viewExpression.ViewExpression;
import org.apache.iotdb.commons.schema.view.viewExpression.visitor.ViewExpressionVisitor;

public abstract class BinaryViewExpression
extends ViewExpression {
    protected ViewExpression leftExpression;
    protected ViewExpression rightExpression;

    protected BinaryViewExpression(ViewExpression leftExpression, ViewExpression rightExpression) {
        this.leftExpression = leftExpression;
        this.rightExpression = rightExpression;
    }

    protected BinaryViewExpression(ByteBuffer byteBuffer) {
        this.leftExpression = ViewExpression.deserialize(byteBuffer);
        this.rightExpression = ViewExpression.deserialize(byteBuffer);
    }

    protected BinaryViewExpression(InputStream inputStream) {
        this.leftExpression = ViewExpression.deserialize(inputStream);
        this.rightExpression = ViewExpression.deserialize(inputStream);
    }

    @Override
    public <R, C> R accept(ViewExpressionVisitor<R, C> visitor, C context) {
        return visitor.visitBinaryExpression(this, context);
    }

    @Override
    protected final boolean isLeafOperandInternal() {
        return false;
    }

    @Override
    public final List<ViewExpression> getChildViewExpressions() {
        return Arrays.asList(this.leftExpression, this.rightExpression);
    }

    @Override
    protected void serialize(ByteBuffer byteBuffer) {
        ViewExpression.serialize(this.leftExpression, byteBuffer);
        ViewExpression.serialize(this.rightExpression, byteBuffer);
    }

    @Override
    protected void serialize(OutputStream stream) throws IOException {
        ViewExpression.serialize(this.leftExpression, stream);
        ViewExpression.serialize(this.rightExpression, stream);
    }

    public void setLeftExpression(ViewExpression leftExpression) {
        this.leftExpression = leftExpression;
    }

    public void setRightExpression(ViewExpression rightExpression) {
        this.rightExpression = rightExpression;
    }

    public ViewExpression getLeftExpression() {
        return this.leftExpression;
    }

    public ViewExpression getRightExpression() {
        return this.rightExpression;
    }

    public abstract String getStringSymbol();

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean isRoot) {
        String basicString = this.leftExpression.toString(false) + " " + this.getStringSymbol() + " " + this.rightExpression.toString(false);
        if (isRoot) {
            return basicString;
        }
        return "(" + basicString + ")";
    }
}

