/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.util.concurrent;

import java.lang.management.ManagementFactory;
import java.util.List;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.james.util.concurrent.JMXEnabledScheduledThreadPoolExecutorMBean;
import org.apache.james.util.concurrent.NamedThreadFactory;

public class JMXEnabledScheduledThreadPoolExecutor
extends ScheduledThreadPoolExecutor
implements JMXEnabledScheduledThreadPoolExecutorMBean {
    private final String jmxPath;
    private final ThreadLocal<Long> startTime = new ThreadLocal();
    private final AtomicLong totalTime = new AtomicLong(0L);
    private final AtomicInteger totalTasks = new AtomicInteger(0);
    private MBeanServer mbeanServer;
    private String mbeanName;

    public JMXEnabledScheduledThreadPoolExecutor(int corePoolSize, NamedThreadFactory threadFactory, String jmxPath) {
        super(corePoolSize, threadFactory);
        this.jmxPath = jmxPath;
        this.registerMBean();
    }

    public JMXEnabledScheduledThreadPoolExecutor(int corePoolSize, String jmxPath, String name) {
        super(corePoolSize, NamedThreadFactory.withName(name));
        this.jmxPath = jmxPath;
        this.registerMBean();
    }

    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        super.beforeExecute(t, r);
        this.startTime.set(System.currentTimeMillis());
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        long time = System.currentTimeMillis() - this.startTime.get();
        this.totalTasks.incrementAndGet();
        this.totalTime.addAndGet(time);
        super.afterExecute(r, t);
    }

    private void registerMBean() {
        if (this.jmxPath != null) {
            this.mbeanServer = ManagementFactory.getPlatformMBeanServer();
            this.mbeanName = this.jmxPath + ",threadpool=" + ((NamedThreadFactory)this.getThreadFactory()).getName();
            try {
                this.mbeanServer.registerMBean(this, new ObjectName(this.mbeanName));
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to register mbean", e);
            }
        }
    }

    private void unregisterMBean() {
        if (this.jmxPath != null) {
            try {
                this.mbeanServer.unregisterMBean(new ObjectName(this.mbeanName));
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to unregister mbean", e);
            }
        }
    }

    @Override
    public synchronized void shutdown() {
        if (!this.isShutdown()) {
            this.unregisterMBean();
        }
        super.shutdown();
        this.startTime.remove();
    }

    @Override
    public synchronized List<Runnable> shutdownNow() {
        if (!this.isShutdown()) {
            this.unregisterMBean();
        }
        return super.shutdownNow();
    }

    @Override
    public synchronized int getTotalTasks() {
        return this.totalTasks.get();
    }

    @Override
    public synchronized double getAverageTaskTime() {
        return this.totalTasks.get() == 0 ? 0.0 : (double)(this.totalTime.get() / (long)this.totalTasks.get());
    }

    @Override
    public int getActiveThreads() {
        return this.getPoolSize();
    }

    @Override
    public int getActiveTasks() {
        return this.getActiveCount();
    }

    @Override
    public int getQueuedTasks() {
        return this.getQueue().size();
    }

    @Override
    public int getMaximalThreads() {
        return this.getMaximumPoolSize();
    }
}

