/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.juneau.AnnotationWorkList;
import org.apache.juneau.ContextSession;
import org.apache.juneau.annotation.ContextApply;
import org.apache.juneau.commons.collections.Cache;
import org.apache.juneau.commons.collections.Cache2;
import org.apache.juneau.commons.collections.FluentMap;
import org.apache.juneau.commons.collections.HashKey;
import org.apache.juneau.commons.reflect.AnnotationInfo;
import org.apache.juneau.commons.reflect.AnnotationProvider;
import org.apache.juneau.commons.reflect.AnnotationTraversal;
import org.apache.juneau.commons.reflect.ClassInfo;
import org.apache.juneau.commons.reflect.ClassInfoTyped;
import org.apache.juneau.commons.reflect.ConstructorInfo;
import org.apache.juneau.commons.reflect.ExecutableException;
import org.apache.juneau.commons.reflect.MethodInfo;
import org.apache.juneau.commons.reflect.ReflectionUtils;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;

public abstract class Context {
    private static final Cache<Class<?>, MethodInfo> BUILDER_CREATE_METHODS = Cache.create().supplier(type -> {
        ClassInfoTyped c = ReflectionUtils.info((Class)type);
        return c.getPublicConstructors().stream().filter(ci -> ci.hasNumParameters(1) && !ci.getParameter(0).getParameterType().is(type)).map(ci -> c.getPublicMethod(x -> x.isStatic() && x.isNotDeprecated() && x.hasName("create") && x.hasReturnType(ci.getParameter(0).getParameterType())).orElse(null)).filter(Objects::nonNull).findFirst().orElseThrow(() -> ThrowableUtils.rex((String)"Could not find builder create method on class {0}", (Object[])new Object[]{Utils.cn((Object)type)}));
    }).build();
    private static final Cache2<Class<? extends Context>, Class<? extends Builder>, ConstructorInfo> CONTEXT_CONSTRUCTORS = Cache2.create().supplier((cacheType, builderType) -> {
        ClassInfoTyped ct = ReflectionUtils.info((Class)cacheType);
        ClassInfoTyped bt = ReflectionUtils.info((Class)builderType);
        return (ConstructorInfo)ct.getPublicConstructor(x -> x.hasNumParameters(1) && x.getParameter(0).getParameterType().isParentOf(builderType)).orElseThrow(() -> ThrowableUtils.rex((String)"Public constructor not found: {0}({1})", (Object[])new Object[]{ct.getName(), bt.getName()}));
    }).build();
    private static final AnnotationProvider AP = AnnotationProvider.INSTANCE;
    public static final Predicate<AnnotationInfo<?>> CONTEXT_APPLY_FILTER = x -> x.hasAnnotation(ContextApply.class);
    private final AnnotationProvider annotationProvider;
    private final boolean debug;
    private final List<Annotation> annotations;

    public static Builder createBuilder(Class<? extends Context> type) {
        AssertionUtils.assertArgNotNull((String)"type", type);
        try {
            return ((Builder)((MethodInfo)BUILDER_CREATE_METHODS.get(type)).invoke(null, new Object[0])).type(type);
        }
        catch (ExecutableException e) {
            throw ThrowableUtils.toRex((Throwable)e);
        }
    }

    private static AnnotationWorkList traverse(AnnotationWorkList work, Object x) {
        AnnotationProvider ap = AP;
        CollectionUtils.traverse((Object)x, (T y) -> {
            if (x instanceof Class) {
                Class x2 = (Class)x;
                work.add(CollectionUtils.rstream((List)ap.find((ClassInfo)ReflectionUtils.info((Class)x2), new AnnotationTraversal[0])).filter(CONTEXT_APPLY_FILTER));
            } else if (x instanceof ClassInfo) {
                ClassInfo x2 = (ClassInfo)x;
                work.add(CollectionUtils.rstream((List)ap.find(x2, new AnnotationTraversal[0])).filter(CONTEXT_APPLY_FILTER));
            } else if (x instanceof Method) {
                Method x2 = (Method)x;
                work.add(CollectionUtils.rstream((List)ap.find(ReflectionUtils.info((Method)x2), new AnnotationTraversal[0])).filter(CONTEXT_APPLY_FILTER));
            } else if (x instanceof MethodInfo) {
                MethodInfo x2 = (MethodInfo)x;
                work.add(CollectionUtils.rstream((List)ap.find(x2, new AnnotationTraversal[0])).filter(CONTEXT_APPLY_FILTER));
            } else {
                ThrowableUtils.illegalArg((String)"Invalid type passed to applyAnnotations:  {0}", (Object[])new Object[]{Utils.cn((Object)x)});
            }
        });
        return work;
    }

    protected Context(Builder builder) {
        AssertionUtils.assertArgNotNull((String)"builder", (Object)builder);
        this.init(builder);
        this.annotations = CollectionUtils.copyOf(builder.annotations);
        this.annotationProvider = AnnotationProvider.create().addRuntimeAnnotations(this.annotations).build();
        this.debug = builder.debug;
    }

    protected Context(Context copyFrom) {
        this.annotationProvider = copyFrom.annotationProvider;
        this.annotations = CollectionUtils.copyOf(copyFrom.annotations);
        this.debug = copyFrom.debug;
    }

    public Builder copy() {
        throw ThrowableUtils.unsupportedOp();
    }

    public ContextSession.Builder createSession() {
        throw ThrowableUtils.unsupportedOp();
    }

    public AnnotationProvider getAnnotationProvider() {
        return this.annotationProvider;
    }

    public ContextSession getSession() {
        return this.createSession().build();
    }

    public boolean isDebug() {
        return this.debug;
    }

    public String toString() {
        return Utils.r(this.properties());
    }

    protected void init(Builder builder) {
    }

    protected FluentMap<String, Object> properties() {
        return CollectionUtils.filteredBeanPropertyMap().a((Object)"annotations", this.annotations).a((Object)"debug", (Object)this.debug);
    }

    public static abstract class Builder {
        private boolean debug;
        private final AnnotationWorkList applied = AnnotationWorkList.create();
        private Cache<HashKey, ? extends Context> cache;
        private Class<? extends Context> type;
        private Context impl;
        private List<Annotation> annotations;
        private final List<Object> builders = CollectionUtils.list((Object[])new Object[0]);

        protected Builder() {
            this.debug = (Boolean)Utils.env((String)"Context.debug", (Object)false);
            this.annotations = CollectionUtils.list((Object[])new Annotation[0]);
            this.registerBuilders(this);
            Class<?> dc = this.getClass().getDeclaringClass();
            if (Context.class.isAssignableFrom(dc)) {
                this.type(dc);
            }
        }

        protected Builder(Builder copyFrom) {
            AssertionUtils.assertArgNotNull((String)"copyFrom", (Object)copyFrom);
            this.annotations = CollectionUtils.copyOf(copyFrom.annotations);
            this.debug = copyFrom.debug;
            this.type = copyFrom.type;
            this.registerBuilders(this);
        }

        protected Builder(Context copyFrom) {
            AssertionUtils.assertArgNotNull((String)"copyFrom", (Object)copyFrom);
            this.annotations = CollectionUtils.copyOf(copyFrom.annotations);
            this.debug = copyFrom.debug;
            this.type = copyFrom.getClass();
            this.registerBuilders(this);
        }

        public Builder annotations(Annotation ... values) {
            AssertionUtils.assertArgNoNulls((String)"values", (Object[])values);
            this.annotations(CollectionUtils.l((Object[])values));
            return this;
        }

        public Builder annotations(List<Annotation> values) {
            this.annotations.addAll(AssertionUtils.assertArgNoNulls((String)"values", values));
            return this;
        }

        public Builder apply(AnnotationWorkList work) {
            AssertionUtils.assertArgNotNull((String)"work", (Object)work);
            this.applied.addAll(work);
            work.forEach(x -> this.builders.forEach(x::apply));
            return this;
        }

        public Builder applyAnnotations(Class<?> ... from) {
            AssertionUtils.assertArgNoNulls((String)"from", (Object[])from);
            return this.applyAnnotations((Object[])from);
        }

        public Builder applyAnnotations(Object ... from) {
            AssertionUtils.assertArgNoNulls((String)"from", (Object[])from);
            AnnotationWorkList work = AnnotationWorkList.create();
            Arrays.stream(from).forEach(x -> Context.traverse(work, x));
            return this.apply(work);
        }

        public <T extends Builder> Optional<T> asSubtype(Class<T> subtype) {
            return Utils.opt(((Class)AssertionUtils.assertArgNotNull((String)"subtype", subtype)).isInstance(this) ? (Builder)subtype.cast(this) : null);
        }

        public Context build() {
            return this.innerBuild();
        }

        public final <T extends Context> T build(Class<T> c) {
            if (this.type == null || !((Class)AssertionUtils.assertArgNotNull((String)"c", c)).isAssignableFrom(this.type)) {
                this.type = c;
            }
            return (T)this.innerBuild();
        }

        public Builder cache(Cache<HashKey, ? extends Context> value) {
            this.cache = value;
            return this;
        }

        public boolean canApply(AnnotationWorkList work) {
            return ((AnnotationWorkList)AssertionUtils.assertArgNotNull((String)"work", (Object)work)).stream().anyMatch(x -> this.builders.stream().anyMatch(b -> x.canApply(b)));
        }

        public abstract Builder copy();

        public Builder debug() {
            return this.debug(true);
        }

        public Builder debug(boolean value) {
            this.debug = value;
            return this;
        }

        public AnnotationWorkList getApplied() {
            return this.applied;
        }

        public Optional<Class<?>> getType() {
            return Utils.opt(this.type);
        }

        public HashKey hashKey() {
            return HashKey.of((Object[])new Object[]{this.debug, this.type, this.annotations});
        }

        public Builder impl(Context value) {
            this.impl = value;
            return this;
        }

        public boolean isDebug() {
            return this.debug;
        }

        public Builder type(Class<? extends Context> value) {
            this.type = value;
            return this;
        }

        protected void registerBuilders(Object ... values) {
            AssertionUtils.assertArgNoNulls((String)"values", (Object[])values);
            for (Object b : values) {
                if (b == this) {
                    this.builders.add(b);
                    continue;
                }
                if (b instanceof Builder) {
                    Builder b2 = (Builder)b;
                    this.builders.addAll(b2.builders);
                    continue;
                }
                this.builders.add(b);
            }
        }

        private ConstructorInfo getContextConstructor() {
            return (ConstructorInfo)CONTEXT_CONSTRUCTORS.get(this.type, this.getClass());
        }

        private Context innerBuild() {
            if (this.type == null) {
                throw ThrowableUtils.rex((String)"Type not specified for context builder {0}", (Object[])new Object[]{Utils.cn(this.getClass())});
            }
            if (Utils.nn((Object)this.impl) && this.type.isInstance(this.impl)) {
                return this.type.cast(this.impl);
            }
            if (Utils.nn(this.cache)) {
                return (Context)this.cache.get((Object)this.hashKey(), () -> (Context)this.getContextConstructor().newInstance(new Object[]{this}));
            }
            return (Context)this.getContextConstructor().newInstance(new Object[]{this});
        }
    }
}

