/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.connection.settings;

import aQute.bnd.connection.settings.ProxyDTO;
import aQute.bnd.connection.settings.ServerDTO;
import aQute.bnd.connection.settings.SettingsDTO;
import aQute.bnd.connection.settings.SettingsParser;
import aQute.bnd.exceptions.Exceptions;
import aQute.bnd.header.Attrs;
import aQute.bnd.header.Parameters;
import aQute.bnd.http.HttpClient;
import aQute.bnd.osgi.Processor;
import aQute.bnd.service.url.ProxyHandler;
import aQute.bnd.service.url.URLConnectionHandler;
import aQute.bnd.url.BasicAuthentication;
import aQute.bnd.url.BearerAuthentication;
import aQute.bnd.url.HttpsVerification;
import aQute.bnd.util.home.Home;
import aQute.lib.collections.Iterables;
import aQute.lib.concurrentinit.ConcurrentInitialize;
import aQute.lib.converter.Converter;
import aQute.lib.hex.Hex;
import aQute.lib.io.IO;
import aQute.lib.mavenpasswordobfuscator.MavenPasswordObfuscator;
import aQute.lib.strings.Strings;
import aQute.lib.xpath.XPathParser;
import aQute.libg.glob.Glob;
import aQute.libg.uri.URIUtil;
import aQute.service.reporter.Reporter;
import java.io.File;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.SocketException;
import java.net.URL;
import java.net.URLConnection;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXParseException;

public class ConnectionSettings {
    static final Logger logger = LoggerFactory.getLogger(ConnectionSettings.class);
    public static final String M2_SETTINGS_SECURITY_XML = "~/.m2/settings-security.xml";
    public static final String M2_SETTINGS_SECURITY_PROPERTY = "settings.security";
    private static final String M2_SETTINGS_XML = "~/.m2/settings.xml";
    private static final String BND_CONNECTION_SETTINGS_XML = Home.getUserHomeBnd() + "/connection-settings.xml";
    private static final String CONNECTION_SETTINGS = "-connection-settings";
    private final Processor processor;
    private final HttpClient client;
    private final List<ServerDTO> servers = new ArrayList<ServerDTO>();
    private final ConcurrentInitialize<String> mavenMasterPassphrase;
    private final List<String> parsed = new ArrayList<String>();
    private static final Pattern URI_P = Pattern.compile("([^:/?#]+)://([^:/?#]+)(?::([^:/?#]+))?.*");

    public ConnectionSettings(Processor processor, HttpClient client) throws Exception {
        this.processor = Objects.requireNonNull(processor);
        this.client = client;
        String logfile = processor.getProperty("-connection-log");
        if (Strings.nonNullOrEmpty(logfile)) {
            File file = IO.getFile(logfile);
            file.getParentFile().mkdirs();
            this.client.setLog(file);
        }
        this.mavenMasterPassphrase = new MasterPassphrase(processor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readSettings() throws Exception {
        Parameters connectionSettings = new Parameters(this.processor.mergeProperties(CONNECTION_SETTINGS), this.processor);
        if (connectionSettings.isEmpty()) {
            File file = IO.getFile(BND_CONNECTION_SETTINGS_XML);
            if (!file.isFile() && !(file = IO.getFile(M2_SETTINGS_XML)).isFile()) {
                return;
            }
            this.parse(file);
            return;
        }
        ArrayList<File> tmps = new ArrayList<File>();
        try {
            for (Map.Entry<String, Attrs> entry : connectionSettings.entrySet()) {
                String key = entry.getKey();
                if ("false".equalsIgnoreCase(key)) continue;
                boolean ignoreError = false;
                if (key.startsWith("-")) {
                    ignoreError = true;
                    key = key.substring(1);
                }
                switch (key) {
                    case "maven": {
                        key = M2_SETTINGS_XML;
                        break;
                    }
                    case "bnd": {
                        key = BND_CONNECTION_SETTINGS_XML;
                        break;
                    }
                    case "env": {
                        Attrs attrs = entry.getValue();
                        String variable = attrs.get("var");
                        if (variable == null) {
                            this.processor.error("Specified -connection-settings: %s, with 'env' but the 'var' parameter was not found", connectionSettings);
                            break;
                        }
                        String value = System.getenv(variable);
                        if (value != null) {
                            File tmp = File.createTempFile(variable, ".xml");
                            IO.store((Object)value, tmp);
                            key = IO.absolutePath(tmp);
                            tmps.add(tmp);
                            break;
                        }
                        if (ignoreError) break;
                        this.processor.error("Specified -connection-settings: %s, but no such environment variable %s is found", connectionSettings, variable);
                    }
                }
                key = Processor.removeDuplicateMarker(key);
                if ("server".equals(key)) {
                    this.parseServer(entry.getValue());
                    continue;
                }
                File file = this.processor.getFile(key);
                if (!file.isFile()) {
                    if (ignoreError) continue;
                    Reporter.SetLocation error = this.processor.error("Specified -connection-settings: %s, but no such file or is directory", file);
                    Processor.FileLine header = this.processor.getHeader(CONNECTION_SETTINGS, key);
                    if (header == null) continue;
                    header.set(error);
                    continue;
                }
                this.parse(file);
            }
        }
        finally {
            tmps.forEach(IO::delete);
        }
    }

    private void parseServer(Attrs value) throws Exception {
        this.parsed.add("direct: " + value);
        ServerDTO server = Converter.cnv(ServerDTO.class, (Object)value);
        if (this.isBasicAuth(server) || this.isBearerAuth(server) || this.isPrivateKey(server) || this.isHttpsVerification(server)) {
            if (server.id == null) {
                server.id = "*";
            } else {
                String normalized = ConnectionSettings.normalize(server.id);
                if (server.id != normalized) {
                    server.id = normalized;
                } else if (server.match == null && server.id.indexOf(42) < 0) {
                    server.match = "*" + server.id + "*";
                }
            }
            this.add(server);
        }
    }

    static String normalize(String id) {
        int defaultPort;
        Matcher m = URI_P.matcher(id);
        if (!m.matches()) {
            return id;
        }
        String scheme = m.group(1).toLowerCase(Locale.ROOT);
        String host = m.group(2);
        String port = m.group(3);
        StringBuilder address = new StringBuilder();
        address.append(scheme).append(':').append('/').append('/').append(host);
        if (!(port == null || (defaultPort = URIUtil.getDefaultPort(scheme)) >= 0 && port.equals(Integer.toString(defaultPort)))) {
            address.append(':').append(port);
        }
        return address.toString();
    }

    private boolean isPrivateKey(ServerDTO server) {
        return !this.isEmpty(server.privateKey) && !this.isEmpty(server.passphrase);
    }

    private boolean isBasicAuth(ServerDTO server) {
        return !this.isEmpty(server.username) && !this.isEmpty(server.password);
    }

    private boolean isBearerAuth(ServerDTO server) {
        return this.isEmpty(server.username) && !this.isEmpty(server.password);
    }

    private boolean isHttpsVerification(ServerDTO server) {
        return !this.isEmpty(server.trust);
    }

    private boolean isEmpty(String s) {
        return s == null || s.trim().isEmpty();
    }

    public URLConnectionHandler createURLConnectionHandler(ServerDTO serverDTO) {
        return new SettingsURLConnectionHandler(serverDTO, this.processor);
    }

    public ProxyHandler createProxyHandler(ProxyDTO proxyDTO) {
        return new SettingsProxyHandler(proxyDTO);
    }

    private void parse(File file) throws Exception {
        try {
            assert (file != null) : "File must be set";
            assert (file.isFile()) : "File must be a file and exist";
            this.parsed.add(file.getAbsolutePath());
            SettingsParser parser = new SettingsParser(file);
            SettingsDTO settings = parser.getSettings();
            for (ProxyDTO proxyDTO : settings.proxies) {
                if (!this.isActive(proxyDTO)) continue;
                this.add(proxyDTO);
            }
            ServerDTO deflt = null;
            for (ServerDTO serverDTO : settings.servers) {
                String masterPassphrase;
                String normalized = ConnectionSettings.normalize(serverDTO.id);
                if (serverDTO.id != normalized) {
                    serverDTO.id = normalized;
                } else if (serverDTO.match == null && serverDTO.id.indexOf(42) < 0) {
                    serverDTO.match = "*" + serverDTO.id + "*";
                }
                serverDTO.trust = ConnectionSettings.makeAbsolute(file.getParentFile(), serverDTO.trust);
                if (MavenPasswordObfuscator.isObfuscatedPassword(serverDTO.password) && (masterPassphrase = this.mavenMasterPassphrase.get()) != null) {
                    try {
                        serverDTO.password = MavenPasswordObfuscator.decrypt(serverDTO.password, masterPassphrase);
                    }
                    catch (Exception e) {
                        this.processor.exception(e, "Could not decrypt the password for server %s", serverDTO.id);
                    }
                }
                if ("default".equals(serverDTO.id)) {
                    deflt = serverDTO;
                    continue;
                }
                this.add(serverDTO);
            }
            if (deflt != null) {
                this.add(deflt);
            }
        }
        catch (SAXParseException e) {
            this.processor.error("Invalid XML in connection settings for file : %s: %s", file, e.getMessage());
        }
    }

    private boolean isActive(ProxyDTO proxy) throws SocketException {
        String[] clauses;
        if (!proxy.active) {
            return false;
        }
        String mask = proxy.mask;
        if (mask == null) {
            return true;
        }
        for (String clause : clauses = mask.split("\\s*,\\s*")) {
            try {
                String[] parts = clause.split("\\s*:\\s*");
                Glob g = new Glob(parts[0]);
                byte[] address = null;
                int maskLength = 0;
                if (parts.length > 1) {
                    String[] pp = parts[1].split("/");
                    address = InetAddress.getByName(pp[0]).getAddress();
                    maskLength = pp.length > 1 ? Integer.parseInt(pp[1]) : address.length * 8;
                }
                for (NetworkInterface ni : Iterables.iterable(NetworkInterface.getNetworkInterfaces())) {
                    if (ni == null || !ni.isUp() || !g.matcher(ni.getName()).matches()) continue;
                    if (address == null) {
                        return true;
                    }
                    for (InterfaceAddress ia : ni.getInterfaceAddresses()) {
                        byte[] iaa = ia.getAddress().getAddress();
                        if (address.length != iaa.length || maskLength != 0 && ia.getNetworkPrefixLength() != maskLength || !Arrays.equals(address, iaa)) continue;
                        return true;
                    }
                }
            }
            catch (Exception e) {
                this.processor.exception(e, "Failed to parse proxy 'mask' clause in settings: %s", clause);
            }
        }
        return false;
    }

    public static String makeAbsolute(File cwd, String trust) {
        if (trust == null || trust.trim().isEmpty()) {
            return null;
        }
        return Processor.split(trust).stream().map(part -> ConnectionSettings.resolve(cwd, part)).collect(Collectors.joining(","));
    }

    static String resolve(File dir, String part) {
        return IO.getFile(dir, part).getPath();
    }

    public void add(ServerDTO server) {
        this.servers.add(server);
        if (this.client != null) {
            this.client.addURLConnectionHandler(this.createURLConnectionHandler(server));
        }
    }

    public void add(ProxyDTO proxy) {
        if (this.client != null) {
            this.client.addProxyHandler(this.createProxyHandler(proxy));
        }
    }

    public List<ServerDTO> getServerDTOs() {
        return this.servers;
    }

    public List<String> getParsedFiles() {
        return this.parsed;
    }

    public void report(Formatter f) {
        f.format("-connection-settings          %s%n", this.processor.getProperty(CONNECTION_SETTINGS, "<>"));
        f.format("Parsed files:%n", new Object[0]);
        this.getParsedFiles().forEach(file -> f.format("   %s%n", file));
        this.getServerDTOs().forEach(server -> {
            f.format("%n", new Object[0]);
            f.format("Id                  %s%n", server.id);
            f.format("Username            %s%n", server.username);
            f.format("Password            %s%n", server.password == null ? "<>" : "*******");
            f.format("Private Key         %s%n", server.privateKey == null ? "<>" : "*******");
            f.format("Passphrase          %s%n", server.passphrase == null ? "<>" : "*******");
            if (server.trust != null && !server.trust.trim().isEmpty()) {
                f.format("Trust%n", new Object[0]);
                List<String> paths = Strings.split(server.trust);
                for (String path : paths) {
                    try {
                        File file = new File(path);
                        if (file.isFile()) {
                            f.format("    %s%n", file);
                            ArrayList<X509Certificate> certificates = new ArrayList<X509Certificate>();
                            HttpsVerification.getCertificates(path, certificates);
                            for (X509Certificate certificate : certificates) {
                                f.format("        Subject     %s%n", certificate.getSubjectDN());
                                byte[] bytes = certificate.getSerialNumber().toByteArray();
                                f.format("        Serial Nr   %s%n", Hex.separated(bytes, ":"));
                                f.format("        Issuer      %s%n", certificate.getIssuerDN());
                                f.format("        Type        %s%n", certificate.getType());
                                try {
                                    certificate.checkValidity();
                                    f.format("        Valid       yes%n", new Object[0]);
                                }
                                catch (Exception e) {
                                    f.format("        Valid       %s%n", e.getMessage());
                                }
                            }
                            continue;
                        }
                        f.format("    %s NO SUCH FILE%n", file);
                    }
                    catch (Exception e) {
                        f.format("        Unexpected connection settings  '%s'%n", Exceptions.causes(e));
                    }
                }
                f.format("Verify              %s%n", server.verify);
            }
        });
    }

    private static final class MasterPassphrase
    extends ConcurrentInitialize<String> {
        private final Processor processor;

        MasterPassphrase(Processor processor) {
            this.processor = processor;
        }

        @Override
        public String create() throws Exception {
            String path = System.getProperty(ConnectionSettings.M2_SETTINGS_SECURITY_PROPERTY, ConnectionSettings.M2_SETTINGS_SECURITY_XML);
            File file = IO.getFile(path);
            if (!file.isFile()) {
                logger.info("No Maven security settings file {}", (Object)path);
                return null;
            }
            XPathParser sp = new XPathParser(file);
            String master = sp.parse("/settingsSecurity/master");
            if (master == null || master.isEmpty()) {
                this.processor.warning("Found Maven security settings file %s but not master password in it", path);
                return null;
            }
            if (!MavenPasswordObfuscator.isObfuscatedPassword(master)) {
                this.processor.warning("Master password in %s was not obfuscated, using actual value", path);
                return master;
            }
            try {
                return MavenPasswordObfuscator.decrypt(master, ConnectionSettings.M2_SETTINGS_SECURITY_PROPERTY);
            }
            catch (Exception e) {
                this.processor.exception(e, "Could not decrypt the master password from %s with key %s", path, ConnectionSettings.M2_SETTINGS_SECURITY_PROPERTY);
                return null;
            }
        }
    }

    private static final class SettingsURLConnectionHandler
    implements URLConnectionHandler {
        private final Glob match;
        private final URLConnectionHandler handler;
        private final URLConnectionHandler https;
        private final int maxConcurrentConnections;

        SettingsURLConnectionHandler(ServerDTO serverDTO, Processor processor) {
            this.match = new Glob(serverDTO.match != null ? serverDTO.match : serverDTO.id);
            this.maxConcurrentConnections = serverDTO.maxConcurrentConnections;
            this.handler = serverDTO.password == null ? null : (serverDTO.username != null ? new BasicAuthentication(serverDTO.username, serverDTO.password, processor) : new BearerAuthentication(serverDTO.password, processor));
            boolean hasCerts = serverDTO.trust != null && !serverDTO.trust.isEmpty();
            this.https = !serverDTO.verify || hasCerts ? new HttpsVerification(serverDTO.trust, serverDTO.verify, (Reporter)processor) : null;
        }

        @Override
        public boolean matches(URL url) {
            return this.match.matcher(ConnectionSettings.normalize(url.toString())).matches();
        }

        @Override
        public void handle(URLConnection connection) throws Exception {
            if (this.handler != null) {
                this.handler.handle(connection);
            }
            if (this.https != null && this.isHttps(connection)) {
                this.https.handle(connection);
            }
        }

        @Override
        public int maxConcurrentConnections() {
            return this.maxConcurrentConnections;
        }

        private boolean isHttps(URLConnection connection) {
            return "https".equalsIgnoreCase(connection.getURL().getProtocol());
        }

        public String toString() {
            return "Server [ match=" + this.match + ", handler=" + this.handler + ", maxConcurrentConnections=" + this.maxConcurrentConnections + ", https=" + this.https + "]";
        }
    }

    private static final class SettingsProxyHandler
    implements ProxyHandler {
        private final ProxyDTO proxyDTO;
        private List<Glob> globs;
        private ProxyHandler.ProxySetup proxySetup;

        SettingsProxyHandler(ProxyDTO proxyDTO) {
            this.proxyDTO = proxyDTO;
        }

        @Override
        public ProxyHandler.ProxySetup forURL(URL url) throws Exception {
            Proxy.Type type;
            switch (this.proxyDTO.protocol.toUpperCase(Locale.ROOT)) {
                case "DIRECT": {
                    type = Proxy.Type.DIRECT;
                    break;
                }
                case "HTTP": {
                    type = Proxy.Type.HTTP;
                    if (url.getProtocol().equalsIgnoreCase("http")) break;
                    return null;
                }
                case "HTTPS": {
                    type = Proxy.Type.HTTP;
                    if (url.getProtocol().equalsIgnoreCase("https")) break;
                    return null;
                }
                case "SOCKS": {
                    type = Proxy.Type.SOCKS;
                    break;
                }
                default: {
                    type = Proxy.Type.HTTP;
                }
            }
            if (this.isNonProxyHost(url.getHost())) {
                return null;
            }
            if (this.proxySetup == null) {
                ProxyHandler.ProxySetup pendingProxySetup = new ProxyHandler.ProxySetup();
                if (this.proxyDTO.username != null && this.proxyDTO.password != null) {
                    pendingProxySetup.authentication = new PasswordAuthentication(this.proxyDTO.username, this.proxyDTO.password.toCharArray());
                }
                InetSocketAddress socketAddress = this.proxyDTO.host != null ? new InetSocketAddress(this.proxyDTO.host, this.proxyDTO.port) : new InetSocketAddress(this.proxyDTO.port);
                pendingProxySetup.proxy = new Proxy(type, socketAddress);
                this.proxySetup = pendingProxySetup;
            }
            return this.proxySetup;
        }

        private boolean isNonProxyHost(String host) {
            if (host == null) {
                return false;
            }
            return this.getNonProxyHosts().stream().anyMatch(g -> g.matcher(host).matches());
        }

        private List<Glob> getNonProxyHosts() {
            if (this.globs != null) {
                return this.globs;
            }
            if (this.proxyDTO.nonProxyHosts == null) {
                this.globs = Collections.emptyList();
                return this.globs;
            }
            this.globs = Processor.split(this.proxyDTO.nonProxyHosts, "\\s*\\|\\s*").stream().map(Glob::new).collect(Collectors.toList());
            return this.globs;
        }
    }
}

