/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="Arguments used for the HDFS disable HA command.")
public class ApiHdfsDisableHaArguments {
    @SerializedName(value="activeName")
    private String activeName = null;
    @SerializedName(value="secondaryName")
    private String secondaryName = null;
    @SerializedName(value="startDependentServices")
    private Boolean startDependentServices = null;
    @SerializedName(value="deployClientConfigs")
    private Boolean deployClientConfigs = null;
    @SerializedName(value="disableQuorumStorage")
    private Boolean disableQuorumStorage = null;

    public ApiHdfsDisableHaArguments activeName(String activeName) {
        this.activeName = activeName;
        return this;
    }

    @Schema(description="Name of the the NameNode to be kept.")
    public String getActiveName() {
        return this.activeName;
    }

    public void setActiveName(String activeName) {
        this.activeName = activeName;
    }

    public ApiHdfsDisableHaArguments secondaryName(String secondaryName) {
        this.secondaryName = secondaryName;
        return this;
    }

    @Schema(description="Name of the SecondaryNamenode to associate with the active NameNode.")
    public String getSecondaryName() {
        return this.secondaryName;
    }

    public void setSecondaryName(String secondaryName) {
        this.secondaryName = secondaryName;
    }

    public ApiHdfsDisableHaArguments startDependentServices(Boolean startDependentServices) {
        this.startDependentServices = startDependentServices;
        return this;
    }

    @Schema(description="Whether to re-start dependent services. Defaults to true.")
    public Boolean isStartDependentServices() {
        return this.startDependentServices;
    }

    public void setStartDependentServices(Boolean startDependentServices) {
        this.startDependentServices = startDependentServices;
    }

    public ApiHdfsDisableHaArguments deployClientConfigs(Boolean deployClientConfigs) {
        this.deployClientConfigs = deployClientConfigs;
        return this;
    }

    @Schema(description="Whether to re-deploy client configurations. Defaults to true.")
    public Boolean isDeployClientConfigs() {
        return this.deployClientConfigs;
    }

    public void setDeployClientConfigs(Boolean deployClientConfigs) {
        this.deployClientConfigs = deployClientConfigs;
    }

    public ApiHdfsDisableHaArguments disableQuorumStorage(Boolean disableQuorumStorage) {
        this.disableQuorumStorage = disableQuorumStorage;
        return this;
    }

    @Schema(description="Whether to disable Quorum-based Storage. Defaults to false.  Available since API v2.")
    public Boolean isDisableQuorumStorage() {
        return this.disableQuorumStorage;
    }

    public void setDisableQuorumStorage(Boolean disableQuorumStorage) {
        this.disableQuorumStorage = disableQuorumStorage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiHdfsDisableHaArguments apiHdfsDisableHaArguments = (ApiHdfsDisableHaArguments)o;
        return Objects.equals(this.activeName, apiHdfsDisableHaArguments.activeName) && Objects.equals(this.secondaryName, apiHdfsDisableHaArguments.secondaryName) && Objects.equals(this.startDependentServices, apiHdfsDisableHaArguments.startDependentServices) && Objects.equals(this.deployClientConfigs, apiHdfsDisableHaArguments.deployClientConfigs) && Objects.equals(this.disableQuorumStorage, apiHdfsDisableHaArguments.disableQuorumStorage);
    }

    public int hashCode() {
        return Objects.hash(this.activeName, this.secondaryName, this.startDependentServices, this.deployClientConfigs, this.disableQuorumStorage);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiHdfsDisableHaArguments {\n");
        sb.append("    activeName: ").append(this.toIndentedString(this.activeName)).append("\n");
        sb.append("    secondaryName: ").append(this.toIndentedString(this.secondaryName)).append("\n");
        sb.append("    startDependentServices: ").append(this.toIndentedString(this.startDependentServices)).append("\n");
        sb.append("    deployClientConfigs: ").append(this.toIndentedString(this.deployClientConfigs)).append("\n");
        sb.append("    disableQuorumStorage: ").append(this.toIndentedString(this.disableQuorumStorage)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

