/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup.preferences;

public final class Statistics {
    public static final TimeConsumer FLUSH = new TimeConsumer("Flush");
    public static final TimeConsumer LOAD = new TimeConsumer("Load");
    public static final TimeConsumer REMOVE_NODE = new TimeConsumer("Remove node");
    public static final TimeConsumer CHILDREN_NAMES = new TimeConsumer("Children names");

    private Statistics() {
    }

    public static StopWatch getStopWatch(TimeConsumer consumer) {
        return new StopWatch(consumer);
    }

    public static StopWatch getStopWatch(TimeConsumer consumer, boolean start) {
        StopWatch retval = new StopWatch(consumer);
        if (start) {
            retval.start();
        }
        return retval;
    }

    public static final class StopWatch {
        private long startTime = 0L;
        private final TimeConsumer activity;

        private StopWatch(TimeConsumer activity) {
            this.activity = activity;
        }

        public void start() {
            this.startTime = System.currentTimeMillis();
        }

        public void stop() {
            assert (this.startTime != 0L);
            this.activity.elapsedTime = (int)((long)this.activity.elapsedTime + (System.currentTimeMillis() - this.startTime));
            this.activity.incrementNumerOfCalls();
            this.startTime = 0L;
        }
    }

    public static final class TimeConsumer {
        private int elapsedTime;
        private int numberOfCalls;
        private final String description;

        private TimeConsumer(String description) {
            this.description = description;
        }

        public int getConsumedTime() {
            return this.elapsedTime;
        }

        public int getNumberOfCalls() {
            return this.numberOfCalls;
        }

        public void reset() {
            this.elapsedTime = 0;
            this.numberOfCalls = 0;
        }

        public String toString() {
            return this.description + ": " + this.numberOfCalls + " calls in " + this.elapsedTime + "ms";
        }

        private void incrementNumerOfCalls() {
            ++this.numberOfCalls;
        }
    }
}

