/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import java.util.Map;
import jpt.sun.source.tree.IdentifierTree;
import jpt.sun.source.tree.MemberSelectTree;
import jpt.sun.source.tree.ParenthesizedTree;
import jpt.sun.source.tree.Tree;
import jpt.sun.source.util.TreePath;
import jpt30.lang.model.element.Element;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.openide.util.NbBundle;

public class LeakingThisInConstructor {
    private static final String THIS_KEYWORD = "this";
    private static final String SUPER_KEYWORD = "super";

    public static ErrorDescription hint(HintContext ctx) {
        IdentifierTree it = (IdentifierTree)ctx.getPath().getLeaf();
        CompilationInfo info = ctx.getInfo();
        if (!Utilities.isInConstructor(ctx)) {
            return null;
        }
        Element e = info.getTrees().getElement(ctx.getPath());
        if (e == null || !e.getSimpleName().contentEquals(THIS_KEYWORD)) {
            return null;
        }
        if (ctx.getPath().getParentPath().getLeaf().getKind() != Tree.Kind.METHOD_INVOCATION) {
            return null;
        }
        return ErrorDescriptionFactory.forName(ctx, it, NbBundle.getMessage(LeakingThisInConstructor.class, "MSG_org.netbeans.modules.java.hints.LeakingThisInConstructor"), new Fix[0]);
    }

    public static ErrorDescription hintOnAssignment(HintContext ctx) {
        Map<String, TreePath> variables = ctx.getVariables();
        TreePath thisPath = variables.get("$this");
        if (thisPath.getLeaf().getKind() != Tree.Kind.IDENTIFIER || !((IdentifierTree)thisPath.getLeaf()).getName().contentEquals(THIS_KEYWORD)) {
            return null;
        }
        if (!Utilities.isInConstructor(ctx)) {
            return null;
        }
        TreePath storePath = variables.get("$v");
        Tree t = storePath.getLeaf();
        if (t.getKind() == Tree.Kind.MEMBER_SELECT) {
            IdentifierTree it;
            t = ((MemberSelectTree)t).getExpression();
            while (t != null && t.getKind() == Tree.Kind.PARENTHESIZED) {
                t = ((ParenthesizedTree)t).getExpression();
            }
            if (t == null) {
                return null;
            }
            if (t.getKind() == Tree.Kind.IDENTIFIER && ((it = (IdentifierTree)t).getName().contentEquals(THIS_KEYWORD) || it.getName().contentEquals(SUPER_KEYWORD))) {
                return null;
            }
        } else {
            return null;
        }
        return ErrorDescriptionFactory.forName(ctx, ctx.getPath(), NbBundle.getMessage(LeakingThisInConstructor.class, "MSG_org.netbeans.modules.java.hints.LeakingThisInConstructor"), new Fix[0]);
    }
}

