/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.suggestions;

import java.util.ArrayList;
import java.util.List;
import jpt.sun.source.tree.ClassTree;
import jpt.sun.source.tree.Tree;
import jpt.sun.source.util.TreePath;
import jpt30.lang.model.element.Element;
import jpt30.lang.model.element.ExecutableElement;
import jpt30.lang.model.element.TypeElement;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.modules.java.hints.suggestions.Bundle;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFix;

public class ImplementMethods {
    public static ErrorDescription implementMethods(HintContext ctx) {
        ClassTree clazz = (ClassTree)ctx.getPath().getLeaf();
        Element typeEl = ctx.getInfo().getTrees().getElement(ctx.getPath());
        if (typeEl == null || !typeEl.getKind().isClass()) {
            return null;
        }
        ArrayList<? extends Tree> candidate = new ArrayList<Tree>(clazz.getImplementsClause());
        candidate.add(clazz.getExtendsClause());
        Tree found = null;
        for (Tree tree : candidate) {
            if (ctx.getInfo().getTrees().getSourcePositions().getStartPosition(ctx.getInfo().getCompilationUnit(), tree) > (long)ctx.getCaretLocation() || (long)ctx.getCaretLocation() > ctx.getInfo().getTrees().getSourcePositions().getEndPosition(ctx.getInfo().getCompilationUnit(), tree)) continue;
            found = tree;
            break;
        }
        if (found == null) {
            return null;
        }
        TreePath foundPath = new TreePath(ctx.getPath(), found);
        Element element = ctx.getInfo().getTrees().getElement(foundPath);
        if (element == null || !element.getKind().isClass() && !element.getKind().isInterface()) {
            return null;
        }
        List<ExecutableElement> unimplemented = ImplementMethods.computeUnimplemented(ctx.getInfo(), typeEl, element);
        if (!unimplemented.isEmpty()) {
            return ErrorDescriptionFactory.forName(ctx, foundPath, Bundle.ERR_ImplementMethods(((TypeElement)element).getQualifiedName().toString()), new ImplementFix(ctx.getInfo(), ctx.getPath(), (TypeElement)typeEl, (TypeElement)element).toEditorFix());
        }
        return null;
    }

    private static List<ExecutableElement> computeUnimplemented(CompilationInfo info, Element typeEl, Element supertype) {
        ArrayList<ExecutableElement> unimplemented = new ArrayList<ExecutableElement>();
        for (ExecutableElement executableElement : info.getElementUtilities().findUnimplementedMethods((TypeElement)typeEl)) {
            if (!executableElement.getEnclosingElement().equals(supertype)) continue;
            unimplemented.add(executableElement);
        }
        return unimplemented;
    }

    private static final class ImplementFix
    extends JavaFix {
        private final String displayName;
        private final ElementHandle<TypeElement> type;
        private final ElementHandle<TypeElement> supertype;

        public ImplementFix(CompilationInfo ci, TreePath clazz, TypeElement type, TypeElement supertype) {
            super(ci, clazz);
            this.displayName = supertype.getQualifiedName().toString();
            this.type = ElementHandle.create(type);
            this.supertype = ElementHandle.create(supertype);
        }

        @Override
        protected String getText() {
            return Bundle.FIX_ImplementSuperTypeMethods(this.displayName);
        }

        @Override
        protected void performRewrite(JavaFix.TransformationContext ctx) throws Exception {
            TypeElement type = this.type.resolve(ctx.getWorkingCopy());
            TypeElement supertype = this.supertype.resolve(ctx.getWorkingCopy());
            if (type == null || supertype == null) {
                return;
            }
            GeneratorUtilities gu = GeneratorUtilities.get(ctx.getWorkingCopy());
            ClassTree ct = gu.insertClassMembers((ClassTree)ctx.getPath().getLeaf(), gu.createAbstractMethodImplementations(type, ImplementMethods.computeUnimplemented(ctx.getWorkingCopy(), type, supertype)));
            ctx.getWorkingCopy().rewrite(ctx.getPath().getLeaf(), ct);
        }
    }
}

