/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.parameter;

import java.util.Optional;
import org.apache.nifi.parameter.Parameter;
import org.apache.nifi.parameter.ParameterLookup;
import org.apache.nifi.parameter.ParameterReference;

public class StandardParameterReference
implements ParameterReference {
    private final String parameterName;
    private final int startOffset;
    private final int endOffset;
    private final String referenceText;

    public StandardParameterReference(String parameterName, int startOffset, int endOffset, String referenceText) {
        this.parameterName = parameterName;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.referenceText = referenceText;
    }

    @Override
    public String getParameterName() {
        return this.parameterName;
    }

    @Override
    public int getStartOffset() {
        return this.startOffset;
    }

    @Override
    public int getEndOffset() {
        return this.endOffset;
    }

    @Override
    public String getText() {
        return this.referenceText;
    }

    @Override
    public boolean isEscapeSequence() {
        return false;
    }

    @Override
    public boolean isParameterReference() {
        return true;
    }

    @Override
    public String getValue(ParameterLookup parameterLookup) {
        if (parameterLookup == null) {
            return this.referenceText;
        }
        Optional<Parameter> parameter = parameterLookup.getParameter(this.parameterName);
        return parameter.map(Parameter::getValue).orElse(null);
    }
}

