/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.result.writer;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.toolkit.cli.impl.result.writer.Table;
import org.apache.nifi.toolkit.cli.impl.result.writer.TableColumn;
import org.apache.nifi.toolkit.cli.impl.result.writer.TableWriter;

public class DynamicTableWriter
implements TableWriter {
    @Override
    public void write(Table table, PrintStream output) {
        if (table == null) {
            throw new IllegalArgumentException("Table cannot be null");
        }
        if (output == null) {
            throw new IllegalArgumentException("Output cannot be null");
        }
        if (table.getColumns().isEmpty()) {
            throw new IllegalArgumentException("Table has no columns to write");
        }
        output.println();
        List<TableColumn> columns = table.getColumns();
        List<String[]> rows = table.getRows();
        int numColumns = columns.size();
        Integer[] columnLengths = this.determineColumnLengths(columns, rows);
        List<Object> columnNames = columns.stream().map(c -> c.getName()).collect(Collectors.toList());
        Object[] columnLengthsObj = Arrays.copyOf(columnLengths, numColumns, Object[].class);
        Object[] columnNamesObj = columnNames.toArray(new Object[numColumns]);
        String columnsPatternFormat = String.join((CharSequence)"", Collections.nCopies(numColumns, "%%-%ds   "));
        String columnsPattern = String.format(columnsPatternFormat, columnLengthsObj);
        String header = String.format(columnsPattern, columnNamesObj);
        output.println(header);
        Object[] headerLineValues = new Object[numColumns];
        for (int i = 0; i < numColumns; ++i) {
            int length = columnLengths[i];
            headerLineValues[i] = String.join((CharSequence)"", Collections.nCopies(length, "-"));
        }
        String headerLine = String.format(columnsPattern, headerLineValues);
        output.println(headerLine);
        for (String[] row : rows) {
            Object[] rowValues = new Object[row.length];
            for (int i = 0; i < row.length; ++i) {
                TableColumn column = columns.get(i);
                rowValues[i] = column.isAbbreviated() ? StringUtils.abbreviate((String)row[i], (int)columnLengths[i]) : row[i];
            }
            String rowString = String.format(columnsPattern, rowValues);
            output.println(rowString);
        }
        output.println();
        output.flush();
    }

    private Integer[] determineColumnLengths(List<TableColumn> columns, List<String[]> rows) {
        Integer[] columnLengths = new Integer[columns.size()];
        for (int i = 0; i < columns.size(); ++i) {
            TableColumn column = columns.get(i);
            int maxLengthInColumn = -1;
            for (String[] row : rows) {
                String colVal = row[i];
                if (colVal == null || colVal.length() <= maxLengthInColumn) continue;
                maxLengthInColumn = colVal.length();
            }
            if (maxLengthInColumn < 0) {
                maxLengthInColumn = column.getMinLength();
            }
            maxLengthInColumn = Math.max(maxLengthInColumn, column.getName().length());
            columnLengths[i] = Math.min(maxLengthInColumn, column.getMaxLength());
        }
        return columnLengths;
    }
}

