/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v106.page.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.v106.page.model.FrameId;
import org.openqa.selenium.devtools.v106.page.model.PrerenderFinalStatus;
import org.openqa.selenium.json.JsonInput;

@Beta
public class PrerenderAttemptCompleted {
    private final FrameId initiatingFrameId;
    private final String prerenderingUrl;
    private final PrerenderFinalStatus finalStatus;
    private final Optional<String> reasonDetails;

    public PrerenderAttemptCompleted(FrameId initiatingFrameId, String prerenderingUrl, PrerenderFinalStatus finalStatus, Optional<String> reasonDetails) {
        this.initiatingFrameId = Objects.requireNonNull(initiatingFrameId, "initiatingFrameId is required");
        this.prerenderingUrl = Objects.requireNonNull(prerenderingUrl, "prerenderingUrl is required");
        this.finalStatus = Objects.requireNonNull(finalStatus, "finalStatus is required");
        this.reasonDetails = reasonDetails;
    }

    public FrameId getInitiatingFrameId() {
        return this.initiatingFrameId;
    }

    public String getPrerenderingUrl() {
        return this.prerenderingUrl;
    }

    public PrerenderFinalStatus getFinalStatus() {
        return this.finalStatus;
    }

    public Optional<String> getReasonDetails() {
        return this.reasonDetails;
    }

    private static PrerenderAttemptCompleted fromJson(JsonInput input) {
        FrameId initiatingFrameId = null;
        String prerenderingUrl = null;
        PrerenderFinalStatus finalStatus = null;
        Optional<String> reasonDetails = Optional.empty();
        input.beginObject();
        block12: while (input.hasNext()) {
            switch (input.nextName()) {
                case "initiatingFrameId": {
                    initiatingFrameId = (FrameId)input.read(FrameId.class);
                    continue block12;
                }
                case "prerenderingUrl": {
                    prerenderingUrl = input.nextString();
                    continue block12;
                }
                case "finalStatus": {
                    finalStatus = (PrerenderFinalStatus)((Object)input.read(PrerenderFinalStatus.class));
                    continue block12;
                }
                case "reasonDetails": {
                    reasonDetails = Optional.ofNullable(input.nextString());
                    continue block12;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new PrerenderAttemptCompleted(initiatingFrameId, prerenderingUrl, finalStatus, reasonDetails);
    }
}

