/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.StreamFactoryRegistry;
import opennlp.tools.cmdline.params.BasicFormatParams;
import opennlp.tools.commons.Internal;
import opennlp.tools.formats.AbstractSampleStreamFactory;
import opennlp.tools.formats.ConllXPOSSampleStream;
import opennlp.tools.postag.POSSample;
import opennlp.tools.util.InputStreamFactory;
import opennlp.tools.util.ObjectStream;

@Internal
public class ConllXPOSSampleStreamFactory
extends AbstractSampleStreamFactory<POSSample, Parameters> {
    public static final String CONLLX_FORMAT = "conllx";

    public static void registerFactory() {
        StreamFactoryRegistry.registerFactory(POSSample.class, CONLLX_FORMAT, new ConllXPOSSampleStreamFactory(Parameters.class));
    }

    protected ConllXPOSSampleStreamFactory(Class<Parameters> params) {
        super(params);
    }

    @Override
    public ObjectStream<POSSample> create(String[] args) {
        Parameters params = this.validateBasicFormatParameters(args, Parameters.class);
        try {
            InputStreamFactory inFactory = CmdLineUtil.createInputStreamFactory(params.getData());
            return new ConllXPOSSampleStream(inFactory, StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            CmdLineUtil.handleCreateObjectStreamError(e);
            return null;
        }
    }

    public static interface Parameters
    extends BasicFormatParams {
    }
}

