/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.constraint;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.sf.oval.ConstraintTarget;
import net.sf.oval.ValidationCycle;
import net.sf.oval.Validator;
import net.sf.oval.configuration.annotation.AbstractAnnotationCheck;
import net.sf.oval.constraint.MatchPattern;

public class MatchPatternCheck
extends AbstractAnnotationCheck<MatchPattern> {
    private static final long serialVersionUID = 1L;
    private final List<Pattern> patterns = Validator.getCollectionFactory().createList(2);
    private boolean matchAll = true;

    @Override
    public void configure(MatchPattern constraintAnnotation) {
        super.configure(constraintAnnotation);
        this.setMatchAll(constraintAnnotation.matchAll());
        this.patterns.clear();
        String[] stringPatterns = constraintAnnotation.pattern();
        int[] f = constraintAnnotation.flags();
        int i = 0;
        int l = stringPatterns.length;
        while (i < l) {
            int flag = f.length > i ? f[i] : 0;
            Pattern p = Pattern.compile(stringPatterns[i], flag);
            this.patterns.add(p);
            ++i;
        }
        this.requireMessageVariablesRecreation();
    }

    protected Map<String, String> createMessageVariables() {
        Map<String, String> messageVariables = Validator.getCollectionFactory().createMap(2);
        messageVariables.put("pattern", this.patterns.size() == 1 ? this.patterns.get(0).toString() : this.patterns.toString());
        return messageVariables;
    }

    @Override
    protected ConstraintTarget[] getAppliesToDefault() {
        return new ConstraintTarget[]{ConstraintTarget.VALUES};
    }

    public Pattern[] getPatterns() {
        return this.patterns.toArray(new Pattern[this.patterns.size()]);
    }

    public boolean isMatchAll() {
        return this.matchAll;
    }

    @Override
    public boolean isSatisfied(Object validatedObject, Object valueToValidate, ValidationCycle cycle) {
        if (valueToValidate == null) {
            return true;
        }
        for (Pattern p : this.patterns) {
            boolean matches = p.matcher(valueToValidate.toString()).matches();
            if (matches) {
                if (this.matchAll) continue;
                return true;
            }
            if (!this.matchAll) continue;
            return false;
        }
        return this.matchAll;
    }

    public void setMatchAll(boolean matchAll) {
        this.matchAll = matchAll;
        this.requireMessageVariablesRecreation();
    }

    public void setPattern(Pattern pattern) {
        this.patterns.clear();
        this.patterns.add(pattern);
        this.requireMessageVariablesRecreation();
    }

    public void setPattern(String pattern, int flags) {
        this.patterns.clear();
        this.patterns.add(Pattern.compile(pattern, flags));
        this.requireMessageVariablesRecreation();
    }

    public void setPatterns(Collection<Pattern> patterns) {
        this.patterns.clear();
        this.patterns.addAll(patterns);
        this.requireMessageVariablesRecreation();
    }

    public void setPatterns(Pattern ... patterns) {
        this.patterns.clear();
        Collections.addAll(this.patterns, patterns);
        this.requireMessageVariablesRecreation();
    }
}

