/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.internal;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import net.sf.oval.Check;
import net.sf.oval.CheckExclusion;
import net.sf.oval.Validator;
import net.sf.oval.exception.InvalidConfigurationException;
import net.sf.oval.guard.IsGuarded;
import net.sf.oval.guard.ParameterNameResolver;
import net.sf.oval.guard.PostCheck;
import net.sf.oval.guard.PreCheck;
import net.sf.oval.internal.ContextCache;
import net.sf.oval.internal.Log;
import net.sf.oval.internal.ParameterChecks;
import net.sf.oval.internal.util.ReflectionUtils;

public final class ClassChecks {
    private static final String GUARDING_MAY_NOT_BE_ACTIVATED_MESSAGE = " Class does not implement IsGuarded interface. This indicates, that constraints guarding may not activated for this class.";
    private static final Log LOG = Log.getLog(ClassChecks.class);
    public final Map<Constructor<?>, Map<Integer, ParameterChecks>> checksForConstructorParameters = Validator.getCollectionFactory().createMap(2);
    public final Map<Field, Set<Check>> checksForFields = Validator.getCollectionFactory().createMap();
    public final Map<Method, Map<Integer, ParameterChecks>> checksForMethodParameters = Validator.getCollectionFactory().createMap();
    public final Map<Method, Set<Check>> checksForMethodReturnValues = Validator.getCollectionFactory().createMap();
    public final Map<Method, Set<PostCheck>> checksForMethodsPostExcecution = Validator.getCollectionFactory().createMap();
    public final Map<Method, Set<PreCheck>> checksForMethodsPreExecution = Validator.getCollectionFactory().createMap();
    public final Set<Check> checksForObject = new LinkedHashSet<Check>(2);
    public final Class<?> clazz;
    public final Set<Field> constrainedFields = new LinkedHashSet<Field>();
    public final Set<Method> constrainedMethods = new LinkedHashSet<Method>();
    public final Set<Field> constrainedStaticFields = new LinkedHashSet<Field>();
    public final Set<Method> constrainedStaticMethods = new LinkedHashSet<Method>();
    public boolean isCheckInvariants;
    public final Set<AccessibleObject> methodsWithCheckInvariantsPost = Validator.getCollectionFactory().createSet();
    public final Set<Method> methodsWithCheckInvariantsPre = Validator.getCollectionFactory().createSet();
    private final ParameterNameResolver parameterNameResolver;

    public ClassChecks(Class<?> clazz, ParameterNameResolver parameterNameResolver) {
        LOG.debug("Initializing constraints configuration for class {1}", clazz);
        this.clazz = clazz;
        this.parameterNameResolver = parameterNameResolver;
    }

    private void _addConstructorParameterCheckExclusions(Constructor<?> constructor, int parameterIndex, Object exclusions) throws InvalidConfigurationException {
        ParameterChecks checksOfConstructorParameter = this._getChecksOfConstructorParameter(constructor, parameterIndex);
        if (exclusions instanceof Collection) {
            Collection exclusionsColl = (Collection)exclusions;
            checksOfConstructorParameter.checkExclusions.addAll(exclusionsColl);
        } else {
            Collections.addAll(checksOfConstructorParameter.checkExclusions, (CheckExclusion[])exclusions);
        }
    }

    private void _addConstructorParameterChecks(Constructor<?> constructor, int parameterIndex, Object checks) throws InvalidConfigurationException {
        if (LOG.isDebug() && !IsGuarded.class.isAssignableFrom(this.clazz)) {
            LOG.warn("Constructor parameter constraints may not be validated. Class does not implement IsGuarded interface. This indicates, that constraints guarding may not activated for this class.");
        }
        ParameterChecks checksOfConstructorParameter = this._getChecksOfConstructorParameter(constructor, parameterIndex);
        if (checks instanceof Collection) {
            for (Check check : (Collection)checks) {
                checksOfConstructorParameter.checks.add(check);
                if (check.getContext() != null) continue;
                check.setContext(checksOfConstructorParameter.context);
            }
        } else {
            Check[] checkArray = (Check[])checks;
            int n = checkArray.length;
            int n2 = 0;
            while (n2 < n) {
                Check check = checkArray[n2];
                checksOfConstructorParameter.checks.add(check);
                if (check.getContext() == null) {
                    check.setContext(checksOfConstructorParameter.context);
                }
                ++n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _addFieldChecks(Field field, Object checks) {
        Map<Field, Set<Check>> map = this.checksForFields;
        synchronized (map) {
            Set checksOfField = this.checksForFields.computeIfAbsent(field, f -> {
                if (ReflectionUtils.isStatic(f)) {
                    this.constrainedStaticFields.add((Field)f);
                } else {
                    this.constrainedFields.add((Field)f);
                }
                return new LinkedHashSet(2);
            });
            if (checks instanceof Collection) {
                for (Check check : (Collection)checks) {
                    checksOfField.add(check);
                    if (check.getContext() != null) continue;
                    check.setContext(ContextCache.getFieldContext(field));
                }
            } else {
                Check[] checkArray = (Check[])checks;
                int n = checkArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Check check = checkArray[n2];
                    checksOfField.add(check);
                    if (check.getContext() == null) {
                        check.setContext(ContextCache.getFieldContext(field));
                    }
                    ++n2;
                }
            }
        }
    }

    private void _addMethodParameterCheckExclusions(Method method, int parameterIndex, Object exclusions) throws InvalidConfigurationException {
        ParameterChecks checksOfMethodParameter = this._getChecksOfMethodParameter(method, parameterIndex);
        if (exclusions instanceof Collection) {
            Collection exclusionsColl = (Collection)exclusions;
            checksOfMethodParameter.checkExclusions.addAll(exclusionsColl);
        } else {
            Collections.addAll(checksOfMethodParameter.checkExclusions, (CheckExclusion[])exclusions);
        }
    }

    private void _addMethodParameterChecks(Method method, int parameterIndex, Object checks) throws InvalidConfigurationException {
        if (LOG.isDebug() && !IsGuarded.class.isAssignableFrom(this.clazz)) {
            LOG.warn("Method parameter constraints may not be validated. Class does not implement IsGuarded interface. This indicates, that constraints guarding may not activated for this class.");
        }
        ParameterChecks checksOfMethodParameter = this._getChecksOfMethodParameter(method, parameterIndex);
        if (checks instanceof Collection) {
            for (Check check : (Collection)checks) {
                if (check.getContext() == null) {
                    check.setContext(checksOfMethodParameter.context);
                }
                checksOfMethodParameter.checks.add(check);
            }
        } else {
            Check[] checkArray = (Check[])checks;
            int n = checkArray.length;
            int n2 = 0;
            while (n2 < n) {
                Check check = checkArray[n2];
                if (check.getContext() == null) {
                    check.setContext(checksOfMethodParameter.context);
                }
                checksOfMethodParameter.checks.add(check);
                ++n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _addMethodPostChecks(Method method, Object checks) throws InvalidConfigurationException {
        if (LOG.isDebug() && !IsGuarded.class.isAssignableFrom(this.clazz)) {
            LOG.warn("Method post-conditions may not be validated. Class does not implement IsGuarded interface. This indicates, that constraints guarding may not activated for this class.");
        }
        Map<Method, Set<PostCheck>> map = this.checksForMethodsPostExcecution;
        synchronized (map) {
            Set postChecks = this.checksForMethodsPostExcecution.computeIfAbsent(method, m -> new LinkedHashSet(2));
            if (checks instanceof Collection) {
                for (PostCheck check : (Collection)checks) {
                    postChecks.add(check);
                    if (check.getContext() != null) continue;
                    check.setContext(ContextCache.getMethodExitContext(method));
                }
            } else {
                PostCheck[] postCheckArray = (PostCheck[])checks;
                int n = postCheckArray.length;
                int n2 = 0;
                while (n2 < n) {
                    PostCheck check = postCheckArray[n2];
                    postChecks.add(check);
                    if (check.getContext() == null) {
                        check.setContext(ContextCache.getMethodExitContext(method));
                    }
                    ++n2;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _addMethodPreChecks(Method method, Object checks) throws InvalidConfigurationException {
        if (LOG.isDebug() && !IsGuarded.class.isAssignableFrom(this.clazz)) {
            LOG.warn("Method pre-conditions may not be validated. Class does not implement IsGuarded interface. This indicates, that constraints guarding may not activated for this class.");
        }
        Map<Method, Set<PreCheck>> map = this.checksForMethodsPreExecution;
        synchronized (map) {
            Set preChecks = this.checksForMethodsPreExecution.computeIfAbsent(method, m -> new LinkedHashSet(2));
            if (checks instanceof Collection) {
                for (PreCheck check : (Collection)checks) {
                    preChecks.add(check);
                    if (check.getContext() != null) continue;
                    check.setContext(ContextCache.getMethodEntryContext(method));
                }
            } else {
                PreCheck[] preCheckArray = (PreCheck[])checks;
                int n = preCheckArray.length;
                int n2 = 0;
                while (n2 < n) {
                    PreCheck check = preCheckArray[n2];
                    preChecks.add(check);
                    if (check.getContext() == null) {
                        check.setContext(ContextCache.getMethodEntryContext(method));
                    }
                    ++n2;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _addMethodReturnValueChecks(Method method, Boolean isInvariant, Object checks) throws InvalidConfigurationException {
        boolean isInvariant2;
        boolean hasParameters;
        if (method.getReturnType() == Void.TYPE) {
            throw new InvalidConfigurationException("Adding return value constraints for method " + method + " is not possible. The method is declared as void and does not return any values.");
        }
        if (ReflectionUtils.isVoidMethod(method)) {
            throw new InvalidConfigurationException("Cannot apply method return value constraints for void method " + method);
        }
        boolean bl = hasParameters = method.getParameterTypes().length > 0;
        if (hasParameters && LOG.isDebug() && !IsGuarded.class.isAssignableFrom(this.clazz)) {
            LOG.warn("Method return value constraints may not be validated. Class does not implement IsGuarded interface. This indicates, that constraints guarding may not activated for this class.");
        }
        boolean bl2 = isInvariant2 = isInvariant == null ? this.constrainedMethods.contains(method) : isInvariant.booleanValue();
        if (!isInvariant2 && LOG.isDebug() && !IsGuarded.class.isAssignableFrom(this.clazz)) {
            LOG.warn("Method return value constraints may not be validated. Class does not implement IsGuarded interface. This indicates, that constraints guarding may not activated for this class.");
        }
        Map<Method, Set<Check>> map = this.checksForMethodReturnValues;
        synchronized (map) {
            if (!hasParameters && isInvariant2) {
                if (ReflectionUtils.isStatic(method)) {
                    this.constrainedStaticMethods.add(method);
                } else {
                    this.constrainedMethods.add(method);
                }
            } else if (ReflectionUtils.isStatic(method)) {
                this.constrainedStaticMethods.remove(method);
            } else {
                this.constrainedMethods.remove(method);
            }
            Set methodChecks = this.checksForMethodReturnValues.computeIfAbsent(method, m -> new LinkedHashSet(2));
            if (checks instanceof Collection) {
                for (Check check : (Collection)checks) {
                    methodChecks.add(check);
                    if (check.getContext() != null) continue;
                    check.setContext(ContextCache.getMethodReturnValueContext(method));
                }
            } else {
                Check[] checkArray = (Check[])checks;
                int n = checkArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Check check = checkArray[n2];
                    methodChecks.add(check);
                    if (check.getContext() == null) {
                        check.setContext(ContextCache.getMethodReturnValueContext(method));
                    }
                    ++n2;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ParameterChecks _getChecksOfConstructorParameter(Constructor<?> ctor, int paramIndex) {
        int paramCount = ctor.getParameterTypes().length;
        if (paramIndex < 0 || paramIndex >= paramCount) {
            throw new InvalidConfigurationException("Parameter Index " + paramIndex + " is out of range (0-" + (paramCount - 1) + ")");
        }
        Map<Constructor<?>, Map<Integer, ParameterChecks>> map = this.checksForConstructorParameters;
        synchronized (map) {
            Map checksOfConstructorByParameter = this.checksForConstructorParameters.computeIfAbsent(ctor, c -> Validator.getCollectionFactory().createMap(paramCount));
            ParameterChecks checksOfConstructorParameter = checksOfConstructorByParameter.computeIfAbsent(paramIndex, i -> new ParameterChecks(ctor, paramIndex, this.parameterNameResolver.getParameterNames(ctor)[paramIndex]));
            return checksOfConstructorParameter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ParameterChecks _getChecksOfMethodParameter(Method method, int paramIndex) {
        int paramCount = method.getParameterTypes().length;
        if (paramIndex < 0 || paramIndex >= paramCount) {
            throw new InvalidConfigurationException("Parameter index " + paramIndex + " is out of range (0-" + (paramCount - 1) + ")");
        }
        Map<Method, Map<Integer, ParameterChecks>> map = this.checksForMethodParameters;
        synchronized (map) {
            Map checksOfMethodByParameter = this.checksForMethodParameters.computeIfAbsent(method, m -> Validator.getCollectionFactory().createMap(paramCount));
            ParameterChecks checksOfMethodParameter = checksOfMethodByParameter.computeIfAbsent(paramIndex, i -> new ParameterChecks(method, paramIndex, this.parameterNameResolver.getParameterNames(method)[paramIndex]));
            return checksOfMethodParameter;
        }
    }

    public void addConstructorParameterCheckExclusions(Constructor<?> constructor, int parameterIndex, CheckExclusion ... exclusions) throws InvalidConfigurationException {
        this._addConstructorParameterCheckExclusions(constructor, parameterIndex, exclusions);
    }

    public void addConstructorParameterCheckExclusions(Constructor<?> constructor, int parameterIndex, Collection<CheckExclusion> exclusions) throws InvalidConfigurationException {
        this._addConstructorParameterCheckExclusions(constructor, parameterIndex, exclusions);
    }

    public void addConstructorParameterChecks(Constructor<?> constructor, int parameterIndex, Check ... checks) throws InvalidConfigurationException {
        this._addConstructorParameterChecks(constructor, parameterIndex, checks);
    }

    public void addConstructorParameterChecks(Constructor<?> constructor, int parameterIndex, Collection<Check> checks) throws InvalidConfigurationException {
        this._addConstructorParameterChecks(constructor, parameterIndex, checks);
    }

    public void addFieldChecks(Field field, Check ... checks) throws InvalidConfigurationException {
        this._addFieldChecks(field, checks);
    }

    public void addFieldChecks(Field field, Collection<Check> checks) throws InvalidConfigurationException {
        this._addFieldChecks(field, checks);
    }

    public void addMethodParameterCheckExclusions(Method method, int parameterIndex, CheckExclusion ... exclusions) throws InvalidConfigurationException {
        this._addMethodParameterCheckExclusions(method, parameterIndex, exclusions);
    }

    public void addMethodParameterCheckExclusions(Method method, int parameterIndex, Collection<CheckExclusion> exclusions) throws InvalidConfigurationException {
        this._addMethodParameterCheckExclusions(method, parameterIndex, exclusions);
    }

    public void addMethodParameterChecks(Method method, int parameterIndex, Check ... checks) throws InvalidConfigurationException {
        this._addMethodParameterChecks(method, parameterIndex, checks);
    }

    public void addMethodParameterChecks(Method method, int parameterIndex, Collection<Check> checks) throws InvalidConfigurationException {
        this._addMethodParameterChecks(method, parameterIndex, checks);
    }

    public void addMethodPostChecks(Method method, Collection<PostCheck> checks) throws InvalidConfigurationException {
        this._addMethodPostChecks(method, checks);
    }

    public void addMethodPostChecks(Method method, PostCheck ... checks) throws InvalidConfigurationException {
        this._addMethodPostChecks(method, checks);
    }

    public void addMethodPreChecks(Method method, Collection<PreCheck> checks) throws InvalidConfigurationException {
        this._addMethodPreChecks(method, checks);
    }

    public void addMethodPreChecks(Method method, PreCheck ... checks) throws InvalidConfigurationException {
        this._addMethodPreChecks(method, checks);
    }

    public void addMethodReturnValueChecks(Method method, Boolean isInvariant, Check ... checks) throws InvalidConfigurationException {
        this._addMethodReturnValueChecks(method, isInvariant, checks);
    }

    public void addMethodReturnValueChecks(Method method, Boolean isInvariant, Collection<Check> checks) throws InvalidConfigurationException {
        this._addMethodReturnValueChecks(method, isInvariant, checks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addObjectChecks(Check ... checks) {
        Set<Check> set = this.checksForObject;
        synchronized (set) {
            Check[] checkArray = checks;
            int n = checks.length;
            int n2 = 0;
            while (n2 < n) {
                Check check = checkArray[n2];
                if (check.getContext() == null) {
                    check.setContext(ContextCache.getClassContext(this.clazz));
                }
                this.checksForObject.add(check);
                ++n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addObjectChecks(Collection<Check> checks) {
        Set<Check> set = this.checksForObject;
        synchronized (set) {
            for (Check check : checks) {
                if (check.getContext() == null) {
                    check.setContext(ContextCache.getClassContext(this.clazz));
                }
                this.checksForObject.add(check);
            }
        }
    }

    public synchronized void clear() {
        LOG.debug("Clearing all checks for class {1}", this.clazz);
        this.checksForObject.clear();
        this.checksForMethodsPostExcecution.clear();
        this.checksForMethodsPreExecution.clear();
        this.checksForConstructorParameters.clear();
        this.checksForFields.clear();
        this.checksForMethodReturnValues.clear();
        this.checksForMethodParameters.clear();
        this.constrainedFields.clear();
        this.constrainedStaticFields.clear();
        this.constrainedMethods.clear();
        this.constrainedStaticMethods.clear();
    }

    public void clearConstructorChecks(Constructor<?> constructor) {
        this.clearConstructorParameterChecks(constructor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearConstructorParameterChecks(Constructor<?> constructor) {
        Map<Constructor<?>, Map<Integer, ParameterChecks>> map = this.checksForConstructorParameters;
        synchronized (map) {
            this.checksForConstructorParameters.remove(constructor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearConstructorParameterChecks(Constructor<?> constructor, int parameterIndex) {
        Map<Constructor<?>, Map<Integer, ParameterChecks>> map = this.checksForConstructorParameters;
        synchronized (map) {
            Map<Integer, ParameterChecks> checksOfConstructorByParameter = this.checksForConstructorParameters.get(constructor);
            if (checksOfConstructorByParameter == null) {
                return;
            }
            ParameterChecks checksOfMethodParameter = checksOfConstructorByParameter.get(parameterIndex);
            if (checksOfMethodParameter == null) {
                return;
            }
            checksOfConstructorByParameter.remove(parameterIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearFieldChecks(Field field) {
        Map<Field, Set<Check>> map = this.checksForFields;
        synchronized (map) {
            this.checksForFields.remove(field);
            this.constrainedFields.remove(field);
            this.constrainedStaticFields.remove(field);
        }
    }

    public synchronized void clearMethodChecks(Method method) {
        this.clearMethodParameterChecks(method);
        this.clearMethodReturnValueChecks(method);
        this.clearMethodPreChecks(method);
        this.clearMethodPostChecks(method);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearMethodParameterChecks(Method method) {
        Map<Method, Map<Integer, ParameterChecks>> map = this.checksForMethodParameters;
        synchronized (map) {
            this.checksForMethodParameters.remove(method);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearMethodParameterChecks(Method method, int parameterIndex) {
        Map<Method, Map<Integer, ParameterChecks>> map = this.checksForMethodParameters;
        synchronized (map) {
            Map<Integer, ParameterChecks> checksOfMethodByParameter = this.checksForMethodParameters.get(method);
            if (checksOfMethodByParameter == null) {
                return;
            }
            ParameterChecks checksOfMethodParameter = checksOfMethodByParameter.get(parameterIndex);
            if (checksOfMethodParameter == null) {
                return;
            }
            checksOfMethodByParameter.remove(parameterIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearMethodPostChecks(Method method) {
        Map<Method, Set<PostCheck>> map = this.checksForMethodsPostExcecution;
        synchronized (map) {
            this.checksForMethodsPostExcecution.remove(method);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearMethodPreChecks(Method method) {
        Map<Method, Set<PreCheck>> map = this.checksForMethodsPreExecution;
        synchronized (map) {
            this.checksForMethodsPreExecution.remove(method);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearMethodReturnValueChecks(Method method) {
        Map<Method, Set<Check>> map = this.checksForMethodReturnValues;
        synchronized (map) {
            this.checksForMethodReturnValues.remove(method);
            this.constrainedMethods.remove(method);
            this.constrainedStaticMethods.remove(method);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearObjectChecks() {
        Set<Check> set = this.checksForObject;
        synchronized (set) {
            this.checksForObject.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConstructorParameterCheckExclusions(Constructor<?> constructor, int parameterIndex, CheckExclusion ... exclusions) {
        Map<Constructor<?>, Map<Integer, ParameterChecks>> map = this.checksForConstructorParameters;
        synchronized (map) {
            Map<Integer, ParameterChecks> checksOfConstructorByParameter = this.checksForConstructorParameters.get(constructor);
            if (checksOfConstructorByParameter == null) {
                return;
            }
            ParameterChecks checksOfConstructorParameter = checksOfConstructorByParameter.get(parameterIndex);
            if (checksOfConstructorParameter == null) {
                return;
            }
            CheckExclusion[] checkExclusionArray = exclusions;
            int n = exclusions.length;
            int n2 = 0;
            while (n2 < n) {
                CheckExclusion exclusion = checkExclusionArray[n2];
                checksOfConstructorParameter.checkExclusions.remove(exclusion);
                ++n2;
            }
            if (checksOfConstructorParameter.isEmpty()) {
                checksOfConstructorByParameter.remove(parameterIndex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConstructorParameterChecks(Constructor<?> constructor, int parameterIndex, Check ... checks) {
        Map<Constructor<?>, Map<Integer, ParameterChecks>> map = this.checksForConstructorParameters;
        synchronized (map) {
            Map<Integer, ParameterChecks> checksOfConstructorByParameter = this.checksForConstructorParameters.get(constructor);
            if (checksOfConstructorByParameter == null) {
                return;
            }
            ParameterChecks checksOfConstructorParameter = checksOfConstructorByParameter.get(parameterIndex);
            if (checksOfConstructorParameter == null) {
                return;
            }
            Check[] checkArray = checks;
            int n = checks.length;
            int n2 = 0;
            while (n2 < n) {
                Check check = checkArray[n2];
                checksOfConstructorParameter.checks.remove(check);
                ++n2;
            }
            if (checksOfConstructorParameter.isEmpty()) {
                checksOfConstructorByParameter.remove(parameterIndex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFieldChecks(Field field, Check ... checks) {
        Map<Field, Set<Check>> map = this.checksForFields;
        synchronized (map) {
            Set<Check> checksOfField = this.checksForFields.get(field);
            if (checksOfField == null) {
                return;
            }
            Check[] checkArray = checks;
            int n = checks.length;
            int n2 = 0;
            while (n2 < n) {
                Check check = checkArray[n2];
                checksOfField.remove(check);
                ++n2;
            }
            if (checksOfField.isEmpty()) {
                this.checksForFields.remove(field);
                this.constrainedFields.remove(field);
                this.constrainedStaticFields.remove(field);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMethodParameterCheckExclusions(Method method, int parameterIndex, CheckExclusion ... exclusions) {
        if (parameterIndex < 0 || parameterIndex > method.getParameterTypes().length) {
            throw new InvalidConfigurationException("ParameterIndex is out of range");
        }
        Map<Method, Map<Integer, ParameterChecks>> map = this.checksForMethodParameters;
        synchronized (map) {
            Map<Integer, ParameterChecks> checksOfMethodByParameter = this.checksForMethodParameters.get(method);
            if (checksOfMethodByParameter == null) {
                return;
            }
            ParameterChecks checksOfMethodParameter = checksOfMethodByParameter.get(parameterIndex);
            if (checksOfMethodParameter == null) {
                return;
            }
            CheckExclusion[] checkExclusionArray = exclusions;
            int n = exclusions.length;
            int n2 = 0;
            while (n2 < n) {
                CheckExclusion exclusion = checkExclusionArray[n2];
                checksOfMethodParameter.checkExclusions.remove(exclusion);
                ++n2;
            }
            if (checksOfMethodParameter.isEmpty()) {
                checksOfMethodByParameter.remove(parameterIndex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMethodParameterChecks(Method method, int parameterIndex, Check ... checks) throws InvalidConfigurationException {
        if (parameterIndex < 0 || parameterIndex > method.getParameterTypes().length) {
            throw new InvalidConfigurationException("ParameterIndex is out of range");
        }
        Map<Method, Map<Integer, ParameterChecks>> map = this.checksForMethodParameters;
        synchronized (map) {
            Map<Integer, ParameterChecks> checksOfMethodByParameter = this.checksForMethodParameters.get(method);
            if (checksOfMethodByParameter == null) {
                return;
            }
            ParameterChecks checksOfMethodParameter = checksOfMethodByParameter.get(parameterIndex);
            if (checksOfMethodParameter == null) {
                return;
            }
            Check[] checkArray = checks;
            int n = checks.length;
            int n2 = 0;
            while (n2 < n) {
                Check check = checkArray[n2];
                checksOfMethodParameter.checks.remove(check);
                ++n2;
            }
            if (checksOfMethodParameter.isEmpty()) {
                checksOfMethodByParameter.remove(parameterIndex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMethodPostChecks(Method method, PostCheck ... checks) {
        Map<Method, Set<PostCheck>> map = this.checksForMethodsPostExcecution;
        synchronized (map) {
            Set<PostCheck> checksforMethod = this.checksForMethodsPostExcecution.get(method);
            if (checksforMethod == null) {
                return;
            }
            PostCheck[] postCheckArray = checks;
            int n = checks.length;
            int n2 = 0;
            while (n2 < n) {
                PostCheck check = postCheckArray[n2];
                checksforMethod.remove(check);
                ++n2;
            }
            if (checksforMethod.isEmpty()) {
                this.checksForMethodsPostExcecution.remove(method);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMethodPreChecks(Method method, PreCheck ... checks) {
        Map<Method, Set<PreCheck>> map = this.checksForMethodsPreExecution;
        synchronized (map) {
            Set<PreCheck> checksforMethod = this.checksForMethodsPreExecution.get(method);
            if (checksforMethod == null) {
                return;
            }
            PreCheck[] preCheckArray = checks;
            int n = checks.length;
            int n2 = 0;
            while (n2 < n) {
                PreCheck check = preCheckArray[n2];
                checksforMethod.remove(check);
                ++n2;
            }
            if (checksforMethod.isEmpty()) {
                this.checksForMethodsPreExecution.remove(method);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMethodReturnValueChecks(Method method, Check ... checks) {
        Map<Method, Set<Check>> map = this.checksForMethodReturnValues;
        synchronized (map) {
            Set<Check> checksOfMethod = this.checksForMethodReturnValues.get(method);
            if (checksOfMethod == null) {
                return;
            }
            Check[] checkArray = checks;
            int n = checks.length;
            int n2 = 0;
            while (n2 < n) {
                Check check = checkArray[n2];
                checksOfMethod.remove(check);
                ++n2;
            }
            if (checksOfMethod.isEmpty()) {
                this.checksForMethodReturnValues.remove(method);
                this.constrainedMethods.remove(method);
                this.constrainedStaticMethods.remove(method);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeObjectChecks(Check ... checks) {
        Set<Check> set = this.checksForObject;
        synchronized (set) {
            Check[] checkArray = checks;
            int n = checks.length;
            int n2 = 0;
            while (n2 < n) {
                Check check = checkArray[n2];
                this.checksForObject.remove(check);
                ++n2;
            }
        }
    }
}

