/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.swizzle.stream;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;

public class PushbackInputStream
extends InputStream
implements org.tomitribe.swizzle.stream.PushbackBuffer {
    private final InputStream delegate;
    private final LinkedList<PushbackBuffer> pushbackBuffers = new LinkedList();
    private byte[] markBuffer;
    private int markCount;

    public PushbackInputStream() {
        this(null);
    }

    public PushbackInputStream(InputStream delegate) {
        this.delegate = delegate;
    }

    public InputStream getDelegate() {
        return this.delegate;
    }

    @Override
    public int read() throws IOException {
        int next = -1;
        Iterator iterator = this.pushbackBuffers.iterator();
        while (iterator.hasNext()) {
            PushbackBuffer buffer = (PushbackBuffer)iterator.next();
            if (buffer.hasNext()) {
                next = buffer.next();
                break;
            }
            iterator.remove();
        }
        if (next == -1) {
            next = this.getNextByte();
        }
        if (next != -1) {
            this.addToMarkBuffer((byte)next);
        }
        return next;
    }

    protected int getNextByte() throws IOException {
        if (this.delegate != null) {
            return this.delegate.read();
        }
        return -1;
    }

    protected void addToMarkBuffer(byte b) {
        if (this.markBuffer == null) {
            return;
        }
        if (this.markCount >= this.markBuffer.length) {
            byte[] oldBuf = this.markBuffer;
            this.markBuffer = new byte[oldBuf.length * 2];
            System.arraycopy(oldBuf, 0, this.markBuffer, 0, oldBuf.length);
        }
        this.markBuffer[this.markCount++] = b;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int readlimit) {
        this.markBuffer = new byte[readlimit];
    }

    public void unmark() {
        this.markBuffer = null;
        this.markCount = 0;
    }

    @Override
    public void reset() {
        if (this.markCount > 0) {
            this.pushbackBuffers.addFirst(new PushbackBuffer(this.markBuffer, 0, this.markCount));
        }
        this.unmark();
    }

    @Override
    public void unread(byte[] bytes) {
        this.unread(bytes, 0, bytes.length);
    }

    @Override
    public void unread(byte[] bytes, int off, int len) {
        this.pushbackBuffers.addFirst(new PushbackBuffer(bytes, off, len));
    }

    @Override
    public byte[] getBuffer() {
        int size = 0;
        for (PushbackBuffer buffer : this.pushbackBuffers) {
            size += buffer.size();
        }
        int off = 0;
        byte[] out = new byte[size];
        for (PushbackBuffer buffer : this.pushbackBuffers) {
            off += buffer.copyBuffer(out, off);
        }
        return out;
    }

    private static class PushbackBuffer {
        private final byte[] buf;
        private int pos;
        private final int end;

        private PushbackBuffer(byte[] buf, int off, int len) {
            if (buf == null) {
                throw new NullPointerException("buf is null");
            }
            if (off < 0) {
                throw new IllegalArgumentException("pos is negative");
            }
            if (len < 0) {
                throw new IllegalArgumentException("len is negative");
            }
            if (off + len > buf.length) {
                throw new IllegalArgumentException("off + len is greater then buf size");
            }
            this.buf = buf;
            this.pos = off;
            this.end = off + len;
        }

        public boolean hasNext() {
            return this.pos < this.end;
        }

        public byte next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.buf[this.pos++];
        }

        public int size() {
            return Math.max(this.end - this.pos, 0);
        }

        public int copyBuffer(byte[] outBuf, int off) {
            int size = this.size();
            System.arraycopy(this.buf, this.pos, outBuf, off, size);
            return size;
        }

        public String toString() {
            return new String(this.buf, this.pos, this.end - this.pos);
        }
    }
}

