/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.spi;

import jakarta.faces.FacesException;
import jakarta.faces.context.ExternalContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import org.apache.myfaces.spi.FacesConfigResourceProvider;
import org.apache.myfaces.spi.impl.DefaultFacesConfigResourceProviderFactory;
import org.apache.myfaces.spi.impl.SpiUtils;

public abstract class FacesConfigResourceProviderFactory {
    private static final String FACTORY_KEY = FacesConfigResourceProviderFactory.class.getName();

    public static FacesConfigResourceProviderFactory getFacesConfigResourceProviderFactory(ExternalContext ctx) {
        FacesConfigResourceProviderFactory instance = (FacesConfigResourceProviderFactory)ctx.getApplicationMap().get(FACTORY_KEY);
        if (instance != null) {
            return instance;
        }
        FacesConfigResourceProviderFactory lpf = null;
        try {
            if (System.getSecurityManager() != null) {
                ExternalContext ectx = ctx;
                lpf = (FacesConfigResourceProviderFactory)AccessController.doPrivileged(() -> SpiUtils.build(ectx, FacesConfigResourceProviderFactory.class, DefaultFacesConfigResourceProviderFactory.class));
            } else {
                lpf = (FacesConfigResourceProviderFactory)SpiUtils.build(ctx, FacesConfigResourceProviderFactory.class, DefaultFacesConfigResourceProviderFactory.class);
            }
        }
        catch (PrivilegedActionException pae) {
            throw new FacesException((Throwable)pae);
        }
        if (lpf != null) {
            FacesConfigResourceProviderFactory.setFacesConfigResourceProviderFactory(ctx, lpf);
        }
        return lpf;
    }

    public static void setFacesConfigResourceProviderFactory(ExternalContext ctx, FacesConfigResourceProviderFactory instance) {
        ctx.getApplicationMap().put(FACTORY_KEY, instance);
    }

    public abstract FacesConfigResourceProvider createFacesConfigResourceProvider(ExternalContext var1);
}

