/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.options;

import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.options.RawUrlReference;
import org.ops4j.pax.exam.options.UrlReference;

public class BootClasspathLibraryOption
implements Option {
    private final UrlReference libraryUrl;
    private boolean append;

    public BootClasspathLibraryOption(String libraryUrl) {
        this(new RawUrlReference(libraryUrl));
    }

    public BootClasspathLibraryOption(UrlReference libraryUrl) {
        NullArgumentException.validateNotNull((Object)libraryUrl, (String)"URL");
        this.libraryUrl = libraryUrl;
        this.append = true;
    }

    public BootClasspathLibraryOption beforeFramework() {
        this.append = false;
        return this.itself();
    }

    public BootClasspathLibraryOption afterFramework() {
        this.append = true;
        return this.itself();
    }

    public UrlReference getLibraryUrl() {
        return this.libraryUrl;
    }

    public boolean isBeforeFramework() {
        return !this.append;
    }

    public boolean isAfterFramework() {
        return this.append;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("BootClasspathOption");
        sb.append("{url=").append(this.libraryUrl);
        sb.append(", append=").append(this.append);
        sb.append('}');
        return sb.toString();
    }

    protected BootClasspathLibraryOption itself() {
        return this;
    }
}

