/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.compiler.plugins.kotlin.lower;

import androidx.compose.compiler.plugins.kotlin.FeatureFlags;
import androidx.compose.compiler.plugins.kotlin.ModuleMetrics;
import androidx.compose.compiler.plugins.kotlin.analysis.StabilityInferencer;
import androidx.compose.compiler.plugins.kotlin.lower.AbstractComposeLowering;
import androidx.compose.compiler.plugins.kotlin.lower.AbstractComposeLoweringKt;
import androidx.compose.compiler.plugins.kotlin.lower.DurableKeyVisitor;
import androidx.compose.compiler.plugins.kotlin.lower.ModuleLoweringPass;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.extensions.IrPluginContext;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationsKt;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrParameterKind;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrVarargElement;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import org.jetbrains.kotlin.ir.expressions.impl.IrStringConcatenationImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrVarargImpl;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrDynamicType;
import org.jetbrains.kotlin.ir.types.IrErrorType;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.ir.visitors.IrTransformer;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.utils.exceptions.PlatformExceptionUtilsKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00fa\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B/\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J0\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u00142\u0006\u0010\u0017\u001a\u00020\u00152\b\b\u0002\u0010\u0018\u001a\u00020\u00152\b\b\u0002\u0010\u0019\u001a\u00020\u0015H\u0004J/\u0010\u001a\u001a\u0002H\u001b\"\u0004\b\u0000\u0010\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00150\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u001b0\u001fH\u0004\u00a2\u0006\u0002\u0010 J)\u0010!\u001a\u0002H\u001b\"\u0004\b\u0000\u0010\u001b2\u0006\u0010\"\u001a\u00020\u00152\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u001b0\u001fH\u0004\u00a2\u0006\u0002\u0010#J)\u0010$\u001a\u0002H\u001b\"\u0004\b\u0000\u0010\u001b2\u0006\u0010\"\u001a\u00020\u00152\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u001b0\u001fH\u0004\u00a2\u0006\u0002\u0010#J!\u0010$\u001a\u0002H\u001b\"\u0004\b\u0000\u0010\u001b2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u001b0\u001fH\u0004\u00a2\u0006\u0002\u0010%J\f\u0010&\u001a\u00020\u0015*\u00020'H\u0004J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0016J\u0010\u0010,\u001a\u00020-2\u0006\u0010*\u001a\u00020-H\u0016J\u0010\u0010.\u001a\u00020/2\u0006\u0010*\u001a\u00020/H\u0016J\u0010\u00100\u001a\u0002012\u0006\u00102\u001a\u000203H\u0016J\u0010\u00104\u001a\u0002012\u0006\u00105\u001a\u000206H\u0016J\u0010\u00107\u001a\u00020)2\u0006\u0010*\u001a\u000208H\u0016J\u0010\u00109\u001a\u0002012\u0006\u00105\u001a\u00020:H\u0016J\f\u0010;\u001a\u00020\u0015*\u00020<H\u0004J\f\u0010=\u001a\u00020\u0015*\u00020>H\u0004J\u0010\u0010?\u001a\u00020)2\u0006\u0010*\u001a\u00020>H\u0016J\u0010\u0010@\u001a\u0002012\u0006\u0010A\u001a\u00020BH\u0016J\u0010\u0010C\u001a\u0002012\u0006\u00105\u001a\u00020DH\u0016J\u0010\u0010E\u001a\u0002012\u0006\u00105\u001a\u00020FH\u0016J\u0010\u0010G\u001a\u00020)2\u0006\u0010*\u001a\u00020HH\u0016J\u0010\u0010I\u001a\u00020J2\u0006\u0010K\u001a\u00020JH\u0016J\u0010\u0010L\u001a\u00020M2\u0006\u0010K\u001a\u00020MH\u0016J\u0010\u0010N\u001a\u0002012\u0006\u00105\u001a\u00020OH\u0016J\u0010\u0010P\u001a\u0002012\u0006\u00105\u001a\u00020QH\u0016J\u0010\u0010R\u001a\u0002012\u0006\u00105\u001a\u00020SH\u0016J\u0010\u0010T\u001a\u0002012\u0006\u00105\u001a\u00020UH\u0016J\u0010\u0010V\u001a\u00020W2\u0006\u0010X\u001a\u00020YH\u0016J\u0010\u0010Z\u001a\u00020)2\u0006\u0010*\u001a\u00020[H\u0016J\u0010\u0010\\\u001a\u00020)2\u0006\u0010*\u001a\u00020]H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006^"}, d2={"Landroidx/compose/compiler/plugins/kotlin/lower/DurableKeyTransformer;", "Landroidx/compose/compiler/plugins/kotlin/lower/AbstractComposeLowering;", "Landroidx/compose/compiler/plugins/kotlin/lower/ModuleLoweringPass;", "keyVisitor", "Landroidx/compose/compiler/plugins/kotlin/lower/DurableKeyVisitor;", "context", "Lorg/jetbrains/kotlin/backend/common/extensions/IrPluginContext;", "stabilityInferencer", "Landroidx/compose/compiler/plugins/kotlin/analysis/StabilityInferencer;", "metrics", "Landroidx/compose/compiler/plugins/kotlin/ModuleMetrics;", "featureFlags", "Landroidx/compose/compiler/plugins/kotlin/FeatureFlags;", "<init>", "(Landroidx/compose/compiler/plugins/kotlin/lower/DurableKeyVisitor;Lorg/jetbrains/kotlin/backend/common/extensions/IrPluginContext;Landroidx/compose/compiler/plugins/kotlin/analysis/StabilityInferencer;Landroidx/compose/compiler/plugins/kotlin/ModuleMetrics;Landroidx/compose/compiler/plugins/kotlin/FeatureFlags;)V", "lower", "", "irModule", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "buildKey", "Lkotlin/Pair;", "", "", "prefix", "pathSeparator", "siblingSeparator", "root", "T", "keys", "", "block", "Lkotlin/Function0;", "(Ljava/util/Set;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "enter", "key", "(Ljava/lang/String;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "siblings", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "asJvmFriendlyString", "Lorg/jetbrains/kotlin/name/Name;", "visitClass", "Lorg/jetbrains/kotlin/ir/IrStatement;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "visitFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "visitPackageFragment", "Lorg/jetbrains/kotlin/ir/declarations/IrPackageFragment;", "visitTry", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "aTry", "Lorg/jetbrains/kotlin/ir/expressions/IrTry;", "visitFunctionAccess", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "visitEnumEntry", "Lorg/jetbrains/kotlin/ir/declarations/IrEnumEntry;", "visitVararg", "Lorg/jetbrains/kotlin/ir/expressions/IrVararg;", "asString", "Lorg/jetbrains/kotlin/ir/types/IrType;", "signatureString", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "visitSimpleFunction", "visitLoop", "loop", "Lorg/jetbrains/kotlin/ir/expressions/IrLoop;", "visitStringConcatenation", "Lorg/jetbrains/kotlin/ir/expressions/IrStringConcatenation;", "visitWhen", "Lorg/jetbrains/kotlin/ir/expressions/IrWhen;", "visitValueParameter", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "visitElseBranch", "Lorg/jetbrains/kotlin/ir/expressions/IrElseBranch;", "branch", "visitBranch", "Lorg/jetbrains/kotlin/ir/expressions/IrBranch;", "visitComposite", "Lorg/jetbrains/kotlin/ir/expressions/IrComposite;", "visitBlock", "Lorg/jetbrains/kotlin/ir/expressions/IrBlock;", "visitSetValue", "Lorg/jetbrains/kotlin/ir/expressions/IrSetValue;", "visitSetField", "Lorg/jetbrains/kotlin/ir/expressions/IrSetField;", "visitBlockBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "body", "Lorg/jetbrains/kotlin/ir/expressions/IrBlockBody;", "visitVariable", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "visitProperty", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "kotlin-compose-compiler-plugin"})
@SourceDebugExtension(value={"SMAP\nDurableKeyTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DurableKeyTransformer.kt\nandroidx/compose/compiler/plugins/kotlin/lower/DurableKeyTransformer\n+ 2 AbstractComposeLowering.kt\nandroidx/compose/compiler/plugins/kotlin/lower/AbstractComposeLoweringKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,368:1\n1726#2,5:369\n1915#3,2:374\n1924#3,3:376\n1924#3,3:379\n*S KotlinDebug\n*F\n+ 1 DurableKeyTransformer.kt\nandroidx/compose/compiler/plugins/kotlin/lower/DurableKeyTransformer\n*L\n86#1:369,5\n104#1:374,2\n157#1:376,3\n218#1:379,3\n*E\n"})
public class DurableKeyTransformer
extends AbstractComposeLowering
implements ModuleLoweringPass {
    @NotNull
    private final DurableKeyVisitor keyVisitor;

    public DurableKeyTransformer(@NotNull DurableKeyVisitor keyVisitor, @NotNull IrPluginContext context, @NotNull StabilityInferencer stabilityInferencer, @NotNull ModuleMetrics metrics, @NotNull FeatureFlags featureFlags) {
        Intrinsics.checkNotNullParameter((Object)keyVisitor, (String)"keyVisitor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)stabilityInferencer, (String)"stabilityInferencer");
        Intrinsics.checkNotNullParameter((Object)metrics, (String)"metrics");
        Intrinsics.checkNotNullParameter((Object)featureFlags, (String)"featureFlags");
        super(context, metrics, stabilityInferencer, featureFlags);
        this.keyVisitor = keyVisitor;
    }

    @Override
    public void lower(@NotNull IrModuleFragment irModule) {
        Intrinsics.checkNotNullParameter((Object)irModule, (String)"irModule");
        IrElementTransformerVoidKt.transformChildrenVoid((IrElement)((IrElement)irModule), (IrElementTransformerVoid)this);
    }

    @NotNull
    protected final Pair<String, Boolean> buildKey(@NotNull String prefix, @NotNull String pathSeparator, @NotNull String siblingSeparator) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)pathSeparator, (String)"pathSeparator");
        Intrinsics.checkNotNullParameter((Object)siblingSeparator, (String)"siblingSeparator");
        return this.keyVisitor.buildPath(prefix, pathSeparator, siblingSeparator);
    }

    public static /* synthetic */ Pair buildKey$default(DurableKeyTransformer durableKeyTransformer, String string, String string2, String string3, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: buildKey");
        }
        if ((n & 2) != 0) {
            string2 = "/";
        }
        if ((n & 4) != 0) {
            string3 = ":";
        }
        return durableKeyTransformer.buildKey(string, string2, string3);
    }

    protected final <T> T root(@NotNull Set<String> keys, @NotNull Function0<? extends T> block) {
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        return this.keyVisitor.root(keys, block);
    }

    protected final <T> T enter(@NotNull String key, @NotNull Function0<? extends T> block) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        return this.keyVisitor.enter(key, block);
    }

    protected final <T> T siblings(@NotNull String key, @NotNull Function0<? extends T> block) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        return this.keyVisitor.siblings(key, block);
    }

    protected final <T> T siblings(@NotNull Function0<? extends T> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        return this.keyVisitor.siblings(block);
    }

    @NotNull
    protected final String asJvmFriendlyString(@NotNull Name $this$asJvmFriendlyString) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$asJvmFriendlyString, (String)"<this>");
        if (!$this$asJvmFriendlyString.isSpecial()) {
            String string2 = $this$asJvmFriendlyString.getIdentifier();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getIdentifier(...)");
        } else {
            String string3 = $this$asJvmFriendlyString.asString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"asString(...)");
            string = StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)string3, (char)'<', (char)'$', (boolean)false, (int)4, null), (char)'>', (char)'$', (boolean)false, (int)4, null), (char)' ', (char)'-', (boolean)false, (int)4, null);
        }
        return string;
    }

    @NotNull
    public IrStatement visitClass(@NotNull IrClass declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (IrUtilsKt.isAnnotationClass((IrClass)declaration)) {
            return (IrStatement)declaration;
        }
        return (IrStatement)this.siblings("class-" + this.asJvmFriendlyString(declaration.getName()), () -> DurableKeyTransformer.visitClass$lambda$0(this, declaration));
    }

    @NotNull
    public IrFile visitFile(@NotNull IrFile declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        IrFile file$iv = declaration;
        boolean $i$f$includeFileNameInExceptionTrace = false;
        try {
            boolean bl = false;
            String filePath = declaration.getFileEntry().getName();
            char[] cArray = new char[]{'/'};
            String fileName = (String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)filePath, (char[])cArray, (boolean)false, (int)0, (int)6, null));
            return (IrFile)this.enter("file-" + fileName, () -> DurableKeyTransformer.visitFile$lambda$0$0(this, declaration));
        }
        catch (Exception e$iv) {
            PlatformExceptionUtilsKt.rethrowIntellijPlatformExceptionIfNeeded((Throwable)e$iv);
            throw new Exception("IR lowering failed at: " + IrDeclarationsKt.getName((IrFile)file$iv), e$iv);
        }
    }

    @NotNull
    public IrPackageFragment visitPackageFragment(@NotNull IrPackageFragment declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        return (IrPackageFragment)this.enter("pkg-" + AdditionalIrUtilsKt.getFqNameForIrSerialization((IrDeclarationParent)((IrDeclarationParent)declaration)), () -> DurableKeyTransformer.visitPackageFragment$lambda$0(this, declaration));
    }

    @NotNull
    public IrExpression visitTry(@NotNull IrTry aTry) {
        Intrinsics.checkNotNullParameter((Object)aTry, (String)"aTry");
        aTry.setTryResult((IrExpression)this.enter("try", () -> DurableKeyTransformer.visitTry$lambda$0(aTry, this)));
        this.siblings(() -> DurableKeyTransformer.visitTry$lambda$1(aTry, this));
        aTry.setFinallyExpression((IrExpression)this.enter("finally", () -> DurableKeyTransformer.visitTry$lambda$2(aTry, this)));
        return (IrExpression)aTry;
    }

    @NotNull
    public IrExpression visitFunctionAccess(@NotNull IrFunctionAccessExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        IrFunction owner = ((IrFunctionSymbol)expression.getSymbol()).getOwner();
        if ((expression instanceof IrConstructorCall || expression instanceof IrDelegatingConstructorCall) && IrUtilsKt.isAnnotationClass((IrClass)IrUtilsKt.getParentAsClass((IrDeclaration)((IrDeclaration)owner)))) {
            return (IrExpression)expression;
        }
        String name = this.asJvmFriendlyString(owner.getName());
        return (IrExpression)this.enter("call-" + name, () -> DurableKeyTransformer.visitFunctionAccess$lambda$0(expression, this));
    }

    @NotNull
    public IrStatement visitEnumEntry(@NotNull IrEnumEntry declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        return (IrStatement)this.enter("entry-" + this.asJvmFriendlyString(declaration.getName()), () -> DurableKeyTransformer.visitEnumEntry$lambda$0(this, declaration));
    }

    @NotNull
    public IrExpression visitVararg(@NotNull IrVararg expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        if (!(expression instanceof IrVarargImpl)) {
            return (IrExpression)expression;
        }
        return (IrExpression)this.enter("vararg", () -> DurableKeyTransformer.visitVararg$lambda$0(expression, this));
    }

    @NotNull
    protected final String asString(@NotNull IrType $this$asString) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$asString, (String)"<this>");
        IrType irType = $this$asString;
        if (irType instanceof IrDynamicType) {
            string = "dynamic";
        } else if (irType instanceof IrErrorType) {
            string = "IrErrorType";
        } else if (irType instanceof IrSimpleType) {
            IrSymbolOwner irSymbolOwner = ((IrSimpleType)$this$asString).getClassifier().getOwner();
            Intrinsics.checkNotNull((Object)irSymbolOwner, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName");
            String string2 = ((IrDeclarationWithName)irSymbolOwner).getName().asString();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    @NotNull
    protected final String signatureString(@NotNull IrSimpleFunction $this$signatureString) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$signatureString, (String)"<this>");
        StringBuilder $this$signatureString_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        IrValueParameter irValueParameter = AbstractComposeLoweringKt.firstParameterOfKind((IrFunction)$this$signatureString, IrParameterKind.ExtensionReceiver);
        if (irValueParameter != null) {
            IrValueParameter it = irValueParameter;
            boolean bl2 = false;
            $this$signatureString_u24lambda_u240.append(this.asString(it.getType()));
            $this$signatureString_u24lambda_u240.append(".");
        }
        $this$signatureString_u24lambda_u240.append(this.asJvmFriendlyString($this$signatureString.getName()));
        $this$signatureString_u24lambda_u240.append('(');
        $this$signatureString_u24lambda_u240.append(CollectionsKt.joinToString$default((Iterable)AbstractComposeLoweringKt.getNamedParameters((IrFunction)$this$signatureString), (CharSequence)",", null, null, (int)0, null, arg_0 -> DurableKeyTransformer.signatureString$lambda$0$1(this, arg_0), (int)30, null));
        $this$signatureString_u24lambda_u240.append(')');
        $this$signatureString_u24lambda_u240.append(this.asString($this$signatureString.getReturnType()));
        return stringBuilder.toString();
    }

    @NotNull
    public IrStatement visitSimpleFunction(@NotNull IrSimpleFunction declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        String path = "fun-" + this.signatureString(declaration);
        return (IrStatement)this.enter(path, () -> DurableKeyTransformer.visitSimpleFunction$lambda$0(this, declaration));
    }

    @NotNull
    public IrExpression visitLoop(@NotNull IrLoop loop) {
        Intrinsics.checkNotNullParameter((Object)loop, (String)"loop");
        IrStatementOrigin irStatementOrigin = loop.getOrigin();
        return Intrinsics.areEqual((Object)irStatementOrigin, (Object)IrStatementOrigin.Companion.getWHILE_LOOP()) || Intrinsics.areEqual((Object)irStatementOrigin, (Object)IrStatementOrigin.Companion.getFOR_LOOP_INNER_WHILE()) ? (IrExpression)this.enter("loop", () -> DurableKeyTransformer.visitLoop$lambda$0(loop, this)) : (IrExpression)this.enter("loop", () -> DurableKeyTransformer.visitLoop$lambda$1(loop, this));
    }

    @NotNull
    public IrExpression visitStringConcatenation(@NotNull IrStringConcatenation expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        if (!(expression instanceof IrStringConcatenationImpl)) {
            return (IrExpression)expression;
        }
        return (IrExpression)this.enter("str", () -> DurableKeyTransformer.visitStringConcatenation$lambda$0(this, expression));
    }

    @NotNull
    public IrExpression visitWhen(@NotNull IrWhen expression) {
        IrExpression irExpression;
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        IrStatementOrigin irStatementOrigin = expression.getOrigin();
        if (Intrinsics.areEqual((Object)irStatementOrigin, (Object)IrStatementOrigin.Companion.getANDAND())) {
            expression.getBranches().set(0, ((IrBranch)expression.getBranches().get(0)).transform((IrTransformer)this, null));
            irExpression = (IrExpression)expression;
        } else if (Intrinsics.areEqual((Object)irStatementOrigin, (Object)IrStatementOrigin.Companion.getOROR())) {
            expression.getBranches().set(1, ((IrBranch)expression.getBranches().get(1)).transform((IrTransformer)this, null));
            irExpression = (IrExpression)expression;
        } else {
            irExpression = Intrinsics.areEqual((Object)irStatementOrigin, (Object)IrStatementOrigin.Companion.getIF()) ? (IrExpression)this.siblings("if", () -> DurableKeyTransformer.visitWhen$lambda$0(this, expression)) : (IrExpression)this.siblings("when", () -> DurableKeyTransformer.visitWhen$lambda$1(this, expression));
        }
        return irExpression;
    }

    @NotNull
    public IrStatement visitValueParameter(@NotNull IrValueParameter declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        return (IrStatement)this.enter("param-" + this.asJvmFriendlyString(declaration.getName()), () -> DurableKeyTransformer.visitValueParameter$lambda$0(this, declaration));
    }

    @NotNull
    public IrElseBranch visitElseBranch(@NotNull IrElseBranch branch) {
        Intrinsics.checkNotNullParameter((Object)branch, (String)"branch");
        return (IrElseBranch)BuildersKt.IrElseBranchImpl((int)branch.getStartOffset(), (int)branch.getEndOffset(), (IrExpression)branch.getCondition(), (IrExpression)((IrExpression)this.enter("else", () -> DurableKeyTransformer.visitElseBranch$lambda$0(branch, this))));
    }

    @NotNull
    public IrBranch visitBranch(@NotNull IrBranch branch) {
        Intrinsics.checkNotNullParameter((Object)branch, (String)"branch");
        return (IrBranch)BuildersKt.IrBranchImpl((int)branch.getStartOffset(), (int)branch.getEndOffset(), (IrExpression)((IrExpression)this.enter("cond", () -> DurableKeyTransformer.visitBranch$lambda$0(branch, this))), (IrExpression)((IrExpression)this.enter("branch", () -> DurableKeyTransformer.visitBranch$lambda$1(branch, this))));
    }

    @NotNull
    public IrExpression visitComposite(@NotNull IrComposite expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        return (IrExpression)this.siblings(() -> DurableKeyTransformer.visitComposite$lambda$0(this, expression));
    }

    @NotNull
    public IrExpression visitBlock(@NotNull IrBlock expression) {
        IrExpression irExpression;
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        IrStatementOrigin irStatementOrigin = expression.getOrigin();
        if (Intrinsics.areEqual((Object)irStatementOrigin, (Object)IrStatementOrigin.Companion.getFOR_LOOP()) || Intrinsics.areEqual((Object)irStatementOrigin, (Object)IrStatementOrigin.Companion.getFOR_LOOP_INNER_WHILE())) {
            List list = expression.getStatements();
            IrElement irElement = ((IrStatement)expression.getStatements().get(1)).transform((IrTransformer)this, null);
            Intrinsics.checkNotNull((Object)irElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.IrStatement");
            list.set(1, (IrStatement)irElement);
            irExpression = (IrExpression)expression;
        } else {
            irExpression = (IrExpression)this.siblings(() -> DurableKeyTransformer.visitBlock$lambda$0(this, expression));
        }
        return irExpression;
    }

    @NotNull
    public IrExpression visitSetValue(@NotNull IrSetValue expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        IrValueDeclaration owner = expression.getSymbol().getOwner();
        Name name = owner.getName();
        IrDeclarationOrigin irDeclarationOrigin = owner.getOrigin();
        return Intrinsics.areEqual((Object)irDeclarationOrigin, (Object)IrDeclarationOrigin.Companion.getFOR_LOOP_IMPLICIT_VARIABLE()) ? (IrExpression)expression : (Intrinsics.areEqual((Object)irDeclarationOrigin, (Object)IrDeclarationOrigin.Companion.getIR_TEMPORARY_VARIABLE()) ? (IrExpression)expression : (Intrinsics.areEqual((Object)irDeclarationOrigin, (Object)IrDeclarationOrigin.Companion.getFOR_LOOP_VARIABLE()) ? (IrExpression)expression : (IrExpression)this.enter("set-" + name, () -> DurableKeyTransformer.visitSetValue$lambda$0(this, expression))));
    }

    @NotNull
    public IrExpression visitSetField(@NotNull IrSetField expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Name name = ((IrField)expression.getSymbol().getOwner()).getName();
        return (IrExpression)this.enter("set-" + name, () -> DurableKeyTransformer.visitSetField$lambda$0(this, expression));
    }

    @NotNull
    public IrBody visitBlockBody(@NotNull IrBlockBody body) {
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        return (IrBody)this.siblings(() -> DurableKeyTransformer.visitBlockBody$lambda$0(this, body));
    }

    @NotNull
    public IrStatement visitVariable(@NotNull IrVariable declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        return (IrStatement)this.enter("val-" + this.asJvmFriendlyString(declaration.getName()), () -> DurableKeyTransformer.visitVariable$lambda$0(this, declaration));
    }

    @NotNull
    public IrStatement visitProperty(@NotNull IrProperty declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        IrField backingField = declaration.getBackingField();
        IrSimpleFunction getter = declaration.getGetter();
        IrSimpleFunction setter = declaration.getSetter();
        String name = this.asJvmFriendlyString(declaration.getName());
        return (IrStatement)this.enter("val-" + name, () -> DurableKeyTransformer.visitProperty$lambda$0(declaration, backingField, this, getter, setter));
    }

    private static final IrStatement visitClass$lambda$0(DurableKeyTransformer this$0, IrClass $declaration) {
        return super.visitClass($declaration);
    }

    private static final IrFile visitFile$lambda$0$0(DurableKeyTransformer this$0, IrFile $declaration) {
        return super.visitFile($declaration);
    }

    private static final IrPackageFragment visitPackageFragment$lambda$0(DurableKeyTransformer this$0, IrPackageFragment $declaration) {
        return super.visitPackageFragment($declaration);
    }

    private static final IrExpression visitTry$lambda$1$0$0(IrCatch $it, DurableKeyTransformer this$0) {
        return $it.getResult().transform((IrTransformer)this$0, null);
    }

    private static final IrExpression visitTry$lambda$0(IrTry $aTry, DurableKeyTransformer this$0) {
        return $aTry.getTryResult().transform((IrTransformer)this$0, null);
    }

    private static final Unit visitTry$lambda$1(IrTry $aTry, DurableKeyTransformer this$0) {
        Iterable $this$forEach$iv = $aTry.getCatches();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrCatch it = (IrCatch)element$iv;
            boolean bl = false;
            it.setResult((IrExpression)this$0.enter("catch", () -> DurableKeyTransformer.visitTry$lambda$1$0$0(it, this$0)));
        }
        return Unit.INSTANCE;
    }

    private static final IrExpression visitTry$lambda$2(IrTry $aTry, DurableKeyTransformer this$0) {
        IrExpression irExpression = $aTry.getFinallyExpression();
        return irExpression != null ? irExpression.transform((IrTransformer)this$0, null) : null;
    }

    private static final Unit visitFunctionAccess$lambda$0$0(IrFunctionAccessExpression $expression, int $i, IrExpression $arg, DurableKeyTransformer this$0) {
        $expression.getArguments().set($i, (Object)$arg.transform((IrTransformer)this$0, null));
        return Unit.INSTANCE;
    }

    private static final IrFunctionAccessExpression visitFunctionAccess$lambda$0(IrFunctionAccessExpression $expression, DurableKeyTransformer this$0) {
        int valueArgCount = 0;
        int n = $expression.getArguments().size();
        for (int i = 0; i < n; ++i) {
            String string;
            IrExpression arg = (IrExpression)$expression.getArguments().get(i);
            switch (WhenMappings.$EnumSwitchMapping$0[((IrValueParameter)((IrFunctionSymbol)$expression.getSymbol()).getOwner().getParameters().get(i)).getKind().ordinal()]) {
                case 1: {
                    string = "$this";
                    break;
                }
                case 2: {
                    string = "$$this";
                    break;
                }
                case 3: 
                case 4: {
                    string = "arg-" + valueArgCount++;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            String label = string;
            if (arg == null) continue;
            this$0.enter(label, () -> DurableKeyTransformer.visitFunctionAccess$lambda$0$0($expression, i, arg, this$0));
        }
        return $expression;
    }

    private static final IrStatement visitEnumEntry$lambda$0(DurableKeyTransformer this$0, IrEnumEntry $declaration) {
        return super.visitEnumEntry($declaration);
    }

    private static final IrVarargElement visitVararg$lambda$0$0$0(IrVarargElement $arg, DurableKeyTransformer this$0) {
        IrElement irElement = $arg.transform((IrTransformer)this$0, null);
        Intrinsics.checkNotNull((Object)irElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrVarargElement");
        return (IrVarargElement)irElement;
    }

    /*
     * WARNING - void declaration
     */
    private static final IrVarargImpl visitVararg$lambda$0(IrVararg $expression, DurableKeyTransformer this$0) {
        Iterable $this$forEachIndexed$iv = ((IrVarargImpl)$expression).getElements();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void arg;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            IrVarargElement irVarargElement = (IrVarargElement)item$iv;
            int i = n;
            boolean bl = false;
            ((IrVarargImpl)$expression).getElements().set(i, this$0.enter(String.valueOf(i), () -> DurableKeyTransformer.visitVararg$lambda$0$0$0((IrVarargElement)arg, this$0)));
        }
        return (IrVarargImpl)$expression;
    }

    private static final CharSequence signatureString$lambda$0$1(DurableKeyTransformer this$0, IrValueParameter it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.asString(it.getType());
    }

    private static final IrStatement visitSimpleFunction$lambda$0(DurableKeyTransformer this$0, IrSimpleFunction $declaration) {
        return super.visitSimpleFunction($declaration);
    }

    private static final IrExpression visitLoop$lambda$0$0(IrLoop $loop, DurableKeyTransformer this$0) {
        IrExpression irExpression = $loop.getBody();
        return irExpression != null ? irExpression.transform((IrTransformer)this$0, null) : null;
    }

    private static final IrExpression visitLoop$lambda$1$0(IrLoop $loop, DurableKeyTransformer this$0) {
        return $loop.getCondition().transform((IrTransformer)this$0, null);
    }

    private static final IrExpression visitLoop$lambda$1$1(IrLoop $loop, DurableKeyTransformer this$0) {
        IrExpression irExpression = $loop.getBody();
        return irExpression != null ? irExpression.transform((IrTransformer)this$0, null) : null;
    }

    private static final IrLoop visitLoop$lambda$0(IrLoop $loop, DurableKeyTransformer this$0) {
        $loop.setBody((IrExpression)this$0.enter("body", () -> DurableKeyTransformer.visitLoop$lambda$0$0($loop, this$0)));
        return $loop;
    }

    private static final IrLoop visitLoop$lambda$1(IrLoop $loop, DurableKeyTransformer this$0) {
        $loop.setCondition((IrExpression)this$0.enter("cond", () -> DurableKeyTransformer.visitLoop$lambda$1$0($loop, this$0)));
        $loop.setBody((IrExpression)this$0.enter("body", () -> DurableKeyTransformer.visitLoop$lambda$1$1($loop, this$0)));
        return $loop;
    }

    private static final IrExpression visitStringConcatenation$lambda$0$0$0$0(IrExpression $expr, DurableKeyTransformer this$0) {
        return $expr.transform((IrTransformer)this$0, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final IrStringConcatenationImpl visitStringConcatenation$lambda$0$0(IrStringConcatenation $expression, DurableKeyTransformer this$0) {
        Iterable $this$forEachIndexed$iv = ((IrStringConcatenationImpl)$expression).getArguments();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void expr;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            IrExpression irExpression = (IrExpression)item$iv;
            int index = n;
            boolean bl = false;
            ((IrStringConcatenationImpl)$expression).getArguments().set(index, this$0.enter(String.valueOf(index), () -> DurableKeyTransformer.visitStringConcatenation$lambda$0$0$0$0((IrExpression)expr, this$0)));
        }
        return (IrStringConcatenationImpl)$expression;
    }

    private static final IrStringConcatenationImpl visitStringConcatenation$lambda$0(DurableKeyTransformer this$0, IrStringConcatenation $expression) {
        return (IrStringConcatenationImpl)this$0.siblings(() -> DurableKeyTransformer.visitStringConcatenation$lambda$0$0($expression, this$0));
    }

    private static final IrExpression visitWhen$lambda$0(DurableKeyTransformer this$0, IrWhen $expression) {
        return super.visitWhen($expression);
    }

    private static final IrExpression visitWhen$lambda$1(DurableKeyTransformer this$0, IrWhen $expression) {
        return super.visitWhen($expression);
    }

    private static final IrStatement visitValueParameter$lambda$0(DurableKeyTransformer this$0, IrValueParameter $declaration) {
        return super.visitValueParameter($declaration);
    }

    private static final IrExpression visitElseBranch$lambda$0(IrElseBranch $branch, DurableKeyTransformer this$0) {
        return $branch.getResult().transform((IrTransformer)this$0, null);
    }

    private static final IrExpression visitBranch$lambda$0(IrBranch $branch, DurableKeyTransformer this$0) {
        return $branch.getCondition().transform((IrTransformer)this$0, null);
    }

    private static final IrExpression visitBranch$lambda$1(IrBranch $branch, DurableKeyTransformer this$0) {
        return $branch.getResult().transform((IrTransformer)this$0, null);
    }

    private static final IrExpression visitComposite$lambda$0(DurableKeyTransformer this$0, IrComposite $expression) {
        return super.visitComposite($expression);
    }

    private static final IrExpression visitBlock$lambda$0(DurableKeyTransformer this$0, IrBlock $expression) {
        return super.visitBlock($expression);
    }

    private static final IrExpression visitSetValue$lambda$0(DurableKeyTransformer this$0, IrSetValue $expression) {
        return super.visitSetValue($expression);
    }

    private static final IrExpression visitSetField$lambda$0(DurableKeyTransformer this$0, IrSetField $expression) {
        return super.visitSetField($expression);
    }

    private static final IrBody visitBlockBody$lambda$0(DurableKeyTransformer this$0, IrBlockBody $body) {
        return super.visitBlockBody($body);
    }

    private static final IrStatement visitVariable$lambda$0(DurableKeyTransformer this$0, IrVariable $declaration) {
        return super.visitVariable($declaration);
    }

    private static final IrSimpleFunction visitProperty$lambda$0$0(IrSimpleFunction $getter, DurableKeyTransformer this$0) {
        IrSimpleFunction irSimpleFunction = $getter;
        IrElement irElement = irSimpleFunction != null ? irSimpleFunction.transform((IrTransformer)this$0, null) : null;
        return irElement instanceof IrSimpleFunction ? (IrSimpleFunction)irElement : null;
    }

    private static final IrSimpleFunction visitProperty$lambda$0$1(IrSimpleFunction $setter, DurableKeyTransformer this$0) {
        IrSimpleFunction irSimpleFunction = $setter;
        IrElement irElement = irSimpleFunction != null ? irSimpleFunction.transform((IrTransformer)this$0, null) : null;
        return irElement instanceof IrSimpleFunction ? (IrSimpleFunction)irElement : null;
    }

    private static final IrProperty visitProperty$lambda$0(IrProperty $declaration, IrField $backingField, DurableKeyTransformer this$0, IrSimpleFunction $getter, IrSimpleFunction $setter) {
        IrField irField = $backingField;
        IrElement irElement = irField != null ? irField.transform((IrTransformer)this$0, null) : null;
        $declaration.setBackingField(irElement instanceof IrField ? (IrField)irElement : null);
        $declaration.setGetter((IrSimpleFunction)this$0.enter("get", () -> DurableKeyTransformer.visitProperty$lambda$0$0($getter, this$0)));
        $declaration.setSetter((IrSimpleFunction)this$0.enter("set", () -> DurableKeyTransformer.visitProperty$lambda$0$1($setter, this$0)));
        return $declaration;
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[IrParameterKind.values().length];
            try {
                nArray[IrParameterKind.DispatchReceiver.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrParameterKind.ExtensionReceiver.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrParameterKind.Context.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrParameterKind.Regular.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

