/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.catalog;

import com.google.common.base.Splitter;
import java.io.IOException;
import java.io.Writer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractSourceGenerator {
    private static final Pattern SEPARATOR_PATTERN = Pattern.compile("[.\\-_]");
    protected final Writer writer;
    private final String ln = System.getProperty("line.separator", "\n");
    private int indent = 0;

    public AbstractSourceGenerator(Writer writer) {
        this.writer = writer;
    }

    static String toJavaName(String alias) {
        return AbstractSourceGenerator.nameSplitter().splitToList((CharSequence)alias).stream().map(StringUtils::capitalize).collect(Collectors.joining());
    }

    protected static Splitter nameSplitter() {
        return Splitter.on((Pattern)SEPARATOR_PATTERN);
    }

    protected void addImport(Class<?> clazz) throws IOException {
        this.addImport(clazz.getCanonicalName());
    }

    protected void addImport(String clazz) throws IOException {
        this.writeLn("import " + clazz + ";");
    }

    protected void writeLn() throws IOException {
        this.writer.write(this.ln);
    }

    public void writeLn(String source) throws IOException {
        this.writeIndent();
        this.writer.write(source + this.ln);
    }

    protected void writeIndent() throws IOException {
        for (int i = 0; i < this.indent; ++i) {
            this.writer.write("    ");
        }
    }

    public void indent(WriteAction action) throws IOException {
        try {
            ++this.indent;
            action.run();
        }
        finally {
            --this.indent;
        }
    }

    @FunctionalInterface
    static interface WriteAction {
        public void run() throws IOException;
    }
}

