/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.datatransfer.importers;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Collection;
import javax.swing.TransferHandler;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;

public abstract class AbstractOsmDataPaster {
    protected final DataFlavor df;

    protected AbstractOsmDataPaster(DataFlavor df) {
        this.df = df;
    }

    public boolean supports(TransferHandler.TransferSupport support) {
        return support.isDataFlavorSupported(this.df) && AbstractOsmDataPaster.isCopy(support);
    }

    public boolean supports(Collection<DataFlavor> available) {
        return available.contains(this.df);
    }

    private static boolean isCopy(TransferHandler.TransferSupport support) {
        return !support.isDrop() || (1 & support.getSourceDropActions()) == 1;
    }

    public abstract boolean importData(TransferHandler.TransferSupport var1, OsmDataLayer var2, EastNorth var3) throws UnsupportedFlavorException, IOException;

    public boolean importTagsOn(TransferHandler.TransferSupport support, Collection<? extends OsmPrimitive> selection) throws UnsupportedFlavorException, IOException {
        return false;
    }
}

