/*
 * Decompiled with CFR 0.152.
 */
package com.elovirta.dita.markdown.renderer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class Metadata {
    public final String id;
    public final List<String> classes;
    public final Map<String, String> attrs;

    public Metadata(String id, List<String> classes, Map<String, String> attrs) {
        this.id = id;
        this.classes = classes;
        this.attrs = attrs;
    }

    public static Metadata parse(String contents) {
        String c = contents.trim();
        ArrayList<String> classes = null;
        HashMap<String, String> attrs = null;
        String fragment = null;
        for (String t : c.split("\\s+")) {
            if (t.startsWith("#")) {
                fragment = t.substring(1);
                continue;
            }
            if (t.startsWith(".")) {
                if (classes == null) {
                    classes = new ArrayList<String>();
                }
                classes.add(t.substring(1));
                continue;
            }
            if (!t.contains("=")) continue;
            String[] tokens = t.split("=", 2);
            String key = tokens[0];
            String value = tokens[1];
            if (key.equals("class")) {
                if (classes == null) {
                    classes = new ArrayList();
                }
                classes.addAll(List.of(value.trim().split("\\s+")));
                continue;
            }
            if (attrs == null) {
                attrs = new HashMap<String, String>();
            }
            attrs.put(key, value);
        }
        String id = fragment;
        return new Metadata(id, Objects.requireNonNullElse(classes, Collections.emptyList()), Objects.requireNonNullElse(attrs, Collections.emptyMap()));
    }
}

