/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc.metrics;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableRatesWithAggregation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
@Metrics(about="Per queue(priority) metrics", context="decayrpcschedulerdetailed")
public class DecayRpcSchedulerDetailedMetrics {
    @Metric
    private MutableRatesWithAggregation rpcQueueRates;
    @Metric
    private MutableRatesWithAggregation rpcProcessingRates;
    private static final Logger LOG = LoggerFactory.getLogger(DecayRpcSchedulerDetailedMetrics.class);
    private final MetricsRegistry registry;
    private final String name;
    private String[] queueNamesForLevels;
    private String[] processingNamesForLevels;

    DecayRpcSchedulerDetailedMetrics(String ns) {
        this.name = "DecayRpcSchedulerDetailedMetrics." + ns;
        this.registry = new MetricsRegistry("decayrpcschedulerdetailed").tag("port", "RPC port", String.valueOf(ns));
        LOG.debug(this.registry.info().toString());
    }

    public static DecayRpcSchedulerDetailedMetrics create(String ns) {
        DecayRpcSchedulerDetailedMetrics m = new DecayRpcSchedulerDetailedMetrics(ns);
        return DefaultMetricsSystem.instance().register(m.name, null, m);
    }

    public void init(int numLevels) {
        LOG.info("Initializing RPC stats for {} priority levels", (Object)numLevels);
        this.queueNamesForLevels = new String[numLevels];
        this.processingNamesForLevels = new String[numLevels];
        for (int i = 0; i < numLevels; ++i) {
            this.queueNamesForLevels[i] = this.getQueueName(i + 1);
            this.processingNamesForLevels[i] = this.getProcessingName(i + 1);
        }
        this.rpcQueueRates.init(this.queueNamesForLevels);
        this.rpcProcessingRates.init(this.processingNamesForLevels);
    }

    public void addQueueTime(int priority, long queueTime) {
        this.rpcQueueRates.add(this.queueNamesForLevels[priority], queueTime);
    }

    public void addProcessingTime(int priority, long processingTime) {
        this.rpcProcessingRates.add(this.processingNamesForLevels[priority], processingTime);
    }

    public void shutdown() {
        DefaultMetricsSystem.instance().unregisterSource(this.name);
    }

    public String getQueueName(int priority) {
        return "DecayRPCSchedulerPriority." + priority + ".RpcQueueTime";
    }

    public String getProcessingName(int priority) {
        return "DecayRPCSchedulerPriority." + priority + ".RpcProcessingTime";
    }

    public String getName() {
        return this.name;
    }

    @VisibleForTesting
    MutableRatesWithAggregation getRpcQueueRates() {
        return this.rpcQueueRates;
    }

    @VisibleForTesting
    MutableRatesWithAggregation getRpcProcessingRates() {
        return this.rpcProcessingRates;
    }
}

