/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import org.apache.iceberg.BaseMetadataTable;
import org.apache.iceberg.HasTableOperations;
import org.apache.iceberg.SerializableTable;
import org.apache.iceberg.Table;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;

public class TableUtil {
    private TableUtil() {
    }

    public static int formatVersion(Table table) {
        Preconditions.checkArgument((null != table ? 1 : 0) != 0, (Object)"Invalid table: null");
        if (table instanceof SerializableTable) {
            SerializableTable serializableTable = (SerializableTable)table;
            return serializableTable.formatVersion();
        }
        if (table instanceof HasTableOperations) {
            HasTableOperations ops = (HasTableOperations)table;
            return ops.operations().current().formatVersion();
        }
        if (table instanceof BaseMetadataTable) {
            BaseMetadataTable metadataTable = (BaseMetadataTable)table;
            return metadataTable.table().operations().current().formatVersion();
        }
        throw new IllegalArgumentException(String.format("%s does not have a format version", table.getClass().getSimpleName()));
    }

    public static String metadataFileLocation(Table table) {
        Preconditions.checkArgument((null != table ? 1 : 0) != 0, (Object)"Invalid table: null");
        if (table instanceof SerializableTable) {
            SerializableTable serializableTable = (SerializableTable)table;
            return serializableTable.metadataFileLocation();
        }
        if (table instanceof HasTableOperations) {
            HasTableOperations ops = (HasTableOperations)table;
            return ops.operations().current().metadataFileLocation();
        }
        if (table instanceof BaseMetadataTable) {
            return ((BaseMetadataTable)table).table().operations().current().metadataFileLocation();
        }
        throw new IllegalArgumentException(String.format("%s does not have a metadata file location", table.getClass().getSimpleName()));
    }

    public static boolean supportsRowLineage(Table table) {
        Preconditions.checkArgument((null != table ? 1 : 0) != 0, (Object)"Invalid table: null");
        if (table instanceof BaseMetadataTable) {
            return false;
        }
        return TableUtil.formatVersion(table) >= 3;
    }
}

