/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.controls;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1Exception;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DecodeableControl;
import com.unboundid.ldap.sdk.JSONControlDecodeHelper;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.ReadOnlyEntry;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.controls.ControlMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import com.unboundid.util.json.JSONArray;
import com.unboundid.util.json.JSONField;
import com.unboundid.util.json.JSONObject;
import com.unboundid.util.json.JSONString;
import com.unboundid.util.json.JSONValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class PostReadResponseControl
extends Control
implements DecodeableControl {
    @NotNull
    public static final String POST_READ_RESPONSE_OID = "1.3.6.1.1.13.2";
    @NotNull
    private static final String JSON_FIELD_DN = "_dn";
    private static final long serialVersionUID = -6918729231330354924L;
    @NotNull
    private final ReadOnlyEntry entry;

    PostReadResponseControl() {
        this.entry = null;
    }

    public PostReadResponseControl(@NotNull ReadOnlyEntry entry) {
        super(POST_READ_RESPONSE_OID, false, PostReadResponseControl.encodeValue(entry));
        this.entry = entry;
    }

    public PostReadResponseControl(@NotNull String oid, boolean isCritical, @Nullable ASN1OctetString value) throws LDAPException {
        super(oid, isCritical, value);
        ASN1Sequence attrSequence;
        ASN1Sequence entrySequence;
        if (value == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_POST_READ_RESPONSE_NO_VALUE.get());
        }
        try {
            ASN1Element entryElement = ASN1Element.decode(value.getValue());
            entrySequence = ASN1Sequence.decodeAsSequence(entryElement);
        }
        catch (ASN1Exception ae) {
            Debug.debugException(ae);
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_POST_READ_RESPONSE_VALUE_NOT_SEQUENCE.get(ae), ae);
        }
        ASN1Element[] entryElements = entrySequence.elements();
        if (entryElements.length != 2) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_POST_READ_RESPONSE_INVALID_ELEMENT_COUNT.get(entryElements.length));
        }
        String dn = ASN1OctetString.decodeAsOctetString(entryElements[0]).stringValue();
        try {
            attrSequence = ASN1Sequence.decodeAsSequence(entryElements[1]);
        }
        catch (ASN1Exception ae) {
            Debug.debugException(ae);
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_POST_READ_RESPONSE_ATTRIBUTES_NOT_SEQUENCE.get(ae), ae);
        }
        ASN1Element[] attrElements = attrSequence.elements();
        Attribute[] attrs = new Attribute[attrElements.length];
        for (int i = 0; i < attrElements.length; ++i) {
            try {
                attrs[i] = Attribute.decode(ASN1Sequence.decodeAsSequence(attrElements[i]));
                continue;
            }
            catch (ASN1Exception ae) {
                Debug.debugException(ae);
                throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_POST_READ_RESPONSE_ATTR_NOT_SEQUENCE.get(ae), ae);
            }
        }
        this.entry = new ReadOnlyEntry(dn, attrs);
    }

    @Override
    @NotNull
    public PostReadResponseControl decodeControl(@NotNull String oid, boolean isCritical, @Nullable ASN1OctetString value) throws LDAPException {
        return new PostReadResponseControl(oid, isCritical, value);
    }

    @Nullable
    public static PostReadResponseControl get(@NotNull LDAPResult result) throws LDAPException {
        Control c = result.getResponseControl(POST_READ_RESPONSE_OID);
        if (c == null) {
            return null;
        }
        if (c instanceof PostReadResponseControl) {
            return (PostReadResponseControl)c;
        }
        return new PostReadResponseControl(c.getOID(), c.isCritical(), c.getValue());
    }

    @NotNull
    private static ASN1OctetString encodeValue(@NotNull ReadOnlyEntry entry) {
        Validator.ensureNotNull(entry);
        Collection<Attribute> attrs = entry.getAttributes();
        ArrayList<ASN1Sequence> attrElements = new ArrayList<ASN1Sequence>(attrs.size());
        for (Attribute a : attrs) {
            attrElements.add(a.encode());
        }
        ASN1Element[] entryElements = new ASN1Element[]{new ASN1OctetString(entry.getDN()), new ASN1Sequence(attrElements)};
        return new ASN1OctetString(new ASN1Sequence(entryElements).encode());
    }

    @NotNull
    public ReadOnlyEntry getEntry() {
        return this.entry;
    }

    @Override
    @NotNull
    public String getControlName() {
        return ControlMessages.INFO_CONTROL_NAME_POST_READ_RESPONSE.get();
    }

    @Override
    @NotNull
    public JSONObject toJSONControl() {
        LinkedHashMap<String, JSONValue> valueFields = new LinkedHashMap<String, JSONValue>();
        valueFields.put(JSON_FIELD_DN, new JSONString(this.entry.getDN()));
        for (Attribute a : this.entry.getAttributes()) {
            ArrayList<JSONString> attrValueValues = new ArrayList<JSONString>(a.size());
            for (String value : a.getValues()) {
                attrValueValues.add(new JSONString(value));
            }
            valueFields.put(a.getName(), new JSONArray(attrValueValues));
        }
        return new JSONObject(new JSONField("oid", POST_READ_RESPONSE_OID), new JSONField("control-name", ControlMessages.INFO_CONTROL_NAME_POST_READ_RESPONSE.get()), new JSONField("criticality", this.isCritical()), new JSONField("value-json", new JSONObject(valueFields)));
    }

    @NotNull
    public static PostReadResponseControl decodeJSONControl(@NotNull JSONObject controlObject, boolean strict) throws LDAPException {
        JSONControlDecodeHelper jsonControl = new JSONControlDecodeHelper(controlObject, strict, true, true);
        ASN1OctetString rawValue = jsonControl.getRawValue();
        if (rawValue != null) {
            return new PostReadResponseControl(jsonControl.getOID(), jsonControl.getCriticality(), rawValue);
        }
        JSONObject valueObject = jsonControl.getValueObject();
        String dn = null;
        ArrayList<Attribute> attributes = new ArrayList<Attribute>(valueObject.getFields().size());
        for (Map.Entry<String, JSONValue> e : valueObject.getFields().entrySet()) {
            String fieldName = e.getKey();
            JSONValue fieldValue = e.getValue();
            if (fieldName.equals(JSON_FIELD_DN)) {
                if (fieldValue instanceof JSONString) {
                    dn = ((JSONString)fieldValue).stringValue();
                    continue;
                }
                throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_POST_READ_RESPONSE_JSON_DN_NOT_STRING.get(controlObject.toSingleLineString(), JSON_FIELD_DN));
            }
            if (fieldValue instanceof JSONArray) {
                List<JSONValue> attrValueValues = ((JSONArray)fieldValue).getValues();
                ArrayList<String> attributeValues = new ArrayList<String>(attrValueValues.size());
                for (JSONValue v : attrValueValues) {
                    if (v instanceof JSONString) {
                        attributeValues.add(((JSONString)v).stringValue());
                        continue;
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_POST_READ_RESPONSE_JSON_ATTR_VALUE_NOT_STRING.get(controlObject.toSingleLineString(), fieldName));
                }
                attributes.add(new Attribute(fieldName, attributeValues));
                continue;
            }
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_POST_READ_RESPONSE_JSON_ATTR_VALUE_NOT_ARRAY.get(controlObject.toSingleLineString(), fieldName));
        }
        if (dn == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_POST_READ_RESPONSE_JSON_MISSING_DN.get(controlObject.toSingleLineString(), JSON_FIELD_DN));
        }
        return new PostReadResponseControl(new ReadOnlyEntry(dn, attributes));
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("PostReadResponseControl(entry=");
        this.entry.toString(buffer);
        buffer.append(", isCritical=");
        buffer.append(this.isCritical());
        buffer.append(')');
    }
}

