/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor.fetch;

import com.github.fge.lambdas.Throwing;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import org.apache.james.imap.api.ImapConstants;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.Capability;
import org.apache.james.imap.api.message.FetchData;
import org.apache.james.imap.api.message.IdRange;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.api.process.SelectedMailbox;
import org.apache.james.imap.message.request.FetchRequest;
import org.apache.james.imap.message.response.FetchResponse;
import org.apache.james.imap.processor.AbstractMailboxProcessor;
import org.apache.james.imap.processor.EnableProcessor;
import org.apache.james.imap.processor.fetch.EnvelopeBuilder;
import org.apache.james.imap.processor.fetch.FetchDataConverter;
import org.apache.james.imap.processor.fetch.FetchResponseBuilder;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.MessageRangeException;
import org.apache.james.mailbox.model.ComposedMessageIdWithMetaData;
import org.apache.james.mailbox.model.FetchGroup;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.mailbox.model.MessageResult;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.util.MDCBuilder;
import org.apache.james.util.ReactorUtils;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class FetchProcessor
extends AbstractMailboxProcessor<FetchRequest> {
    private static final Logger LOGGER = LoggerFactory.getLogger(FetchProcessor.class);

    @Inject
    public FetchProcessor(MailboxManager mailboxManager, StatusResponseFactory factory, MetricFactory metricFactory) {
        super(FetchRequest.class, mailboxManager, factory, metricFactory);
    }

    @Override
    protected Mono<Void> processRequestReactive(FetchRequest request, ImapSession session, ImapProcessor.Responder responder) {
        IdRange[] idSet = request.getIdSet();
        FetchData fetch = this.computeFetchData(request, session);
        long changedSince = fetch.getChangedSince();
        MailboxSession mailboxSession = session.getMailboxSession();
        SelectedMailbox selected = session.getSelected();
        return Optional.ofNullable(selected).map(s -> Mono.from((Publisher)this.getMailboxManager().getMailboxReactive(s.getMailboxId(), mailboxSession))).orElseGet(() -> Mono.error((Throwable)new MailboxException("Session not in SELECTED state"))).flatMap(Throwing.function(mailbox -> {
            boolean vanished = fetch.getVanished();
            if (vanished && !EnableProcessor.getEnabledCapabilities(session).contains(ImapConstants.SUPPORTS_QRESYNC)) {
                this.taggedBad(request, responder, HumanReadableText.QRESYNC_NOT_ENABLED);
                return Mono.empty();
            }
            if (vanished && changedSince == -1L) {
                this.taggedBad(request, responder, HumanReadableText.QRESYNC_VANISHED_WITHOUT_CHANGEDSINCE);
                return Mono.empty();
            }
            boolean constoreCommand = fetch.getChangedSince() != -1L || fetch.contains(FetchData.Item.MODSEQ);
            Set<Capability> enabled = EnableProcessor.getEnabledCapabilities(session);
            if (constoreCommand && !enabled.contains(ImapConstants.SUPPORTS_CONDSTORE)) {
                return mailbox.getMetaDataReactive(MessageManager.MailboxMetaData.RecentMode.IGNORE, mailboxSession, EnumSet.of(MessageManager.MailboxMetaData.Item.HighestModSeq)).doOnNext(metaData -> this.condstoreEnablingCommand(session, responder, (MessageManager.MailboxMetaData)metaData, true)).flatMap(Throwing.function(any -> this.doFetch(selected, request, responder, fetch, mailboxSession, (MessageManager)mailbox, session)).sneakyThrow());
            }
            return this.doFetch(selected, request, responder, fetch, mailboxSession, (MessageManager)mailbox, session);
        }).sneakyThrow()).doOnEach(ReactorUtils.logOnError(MessageRangeException.class, e -> LOGGER.debug("Fetch failed for mailbox {} because of invalid sequence-set {}", new Object[]{selected.getMailboxId(), idSet, e}))).onErrorResume(MessageRangeException.class, e -> {
            this.taggedBad(request, responder, HumanReadableText.INVALID_MESSAGESET);
            return Mono.empty();
        }).doOnEach(ReactorUtils.logOnError(MailboxException.class, e -> LOGGER.error("Fetch failed for mailbox {} and sequence-set {}", new Object[]{selected.getMailboxId(), idSet, e}))).onErrorResume(MailboxException.class, e -> {
            this.no(request, responder, HumanReadableText.SEARCH_FAILED);
            return Mono.empty();
        }).then();
    }

    private Mono<Void> doFetch(SelectedMailbox selected, FetchRequest request, ImapProcessor.Responder responder, FetchData fetch, MailboxSession mailboxSession, MessageManager mailbox, ImapSession session) throws MailboxException {
        ArrayList<MessageRange> ranges = new ArrayList<MessageRange>();
        for (IdRange range : request.getIdSet()) {
            MessageRange messageSet = this.messageRange(session.getSelected(), range, request.isUseUids()).orElseThrow(() -> new MessageRangeException(range.getFormattedString() + " is an invalid range"));
            if (messageSet == null) continue;
            MessageRange normalizedMessageSet = this.normalizeMessageRange(selected, messageSet);
            MessageRange batchedMessageSet = MessageRange.range((MessageUid)normalizedMessageSet.getUidFrom(), (MessageUid)normalizedMessageSet.getUidTo());
            ranges.add(batchedMessageSet);
        }
        if (fetch.getVanished()) {
            this.respondVanished(selected, ranges, responder);
        }
        boolean omitExpunged = !request.isUseUids();
        return this.processMessageRanges(selected, mailbox, ranges, fetch, mailboxSession, responder).then(this.unsolicitedResponses(session, responder, omitExpunged, request.isUseUids())).then(Mono.fromRunnable(() -> this.okComplete(request, responder)));
    }

    private FetchData computeFetchData(FetchRequest request, ImapSession session) {
        if (EnableProcessor.getEnabledCapabilities(session).contains(ImapConstants.SUPPORTS_QRESYNC)) {
            return FetchData.Builder.from(request.getFetch()).fetch(FetchData.Item.UID).build();
        }
        return request.getFetch();
    }

    private Mono<Void> processMessageRanges(SelectedMailbox selected, MessageManager mailbox, List<MessageRange> ranges, FetchData fetch, MailboxSession mailboxSession, ImapProcessor.Responder responder) throws MailboxException {
        FetchResponseBuilder builder = new FetchResponseBuilder(new EnvelopeBuilder());
        FetchGroup resultToFetch = FetchDataConverter.getFetchGroup(fetch);
        return Flux.fromIterable(ranges).concatMap(range -> {
            if (fetch.isOnlyFlags()) {
                return this.processMessageRangeForFlags(selected, mailbox, fetch, mailboxSession, responder, builder, (MessageRange)range);
            }
            return this.processMessageRange(selected, mailbox, fetch, mailboxSession, responder, builder, resultToFetch, (MessageRange)range);
        }).then();
    }

    private Mono<Void> processMessageRangeForFlags(SelectedMailbox selected, MessageManager mailbox, FetchData fetch, MailboxSession mailboxSession, ImapProcessor.Responder responder, FetchResponseBuilder builder, MessageRange range) {
        return Flux.from((Publisher)mailbox.listMessagesMetadata(range, mailboxSession)).filter(ids -> !fetch.contains(FetchData.Item.MODSEQ) || ids.getModSeq().asLong() > fetch.getChangedSince()).concatMap(result -> this.toResponse(mailbox, fetch, mailboxSession, builder, selected, (ComposedMessageIdWithMetaData)result)).doOnNext(responder::respond).then();
    }

    private Mono<FetchResponse> toResponse(MessageManager mailbox, FetchData fetch, MailboxSession mailboxSession, FetchResponseBuilder builder, SelectedMailbox selected, ComposedMessageIdWithMetaData result) {
        try {
            return builder.build(fetch, result, mailbox, selected, mailboxSession);
        }
        catch (MessageRangeException e) {
            LOGGER.debug("Unable to find message with uid {}", (Object)result.getComposedMessageId().getUid(), (Object)e);
            return ReactorUtils.logAsMono(() -> LOGGER.debug("Unable to find message with uid {}", (Object)result.getComposedMessageId().getUid(), (Object)e)).then(Mono.empty());
        }
        catch (MailboxException e) {
            return ReactorUtils.logAsMono(() -> LOGGER.error("Unable to fetch message with uid {}, so skip it", (Object)result.getComposedMessageId().getUid(), (Object)e)).then(Mono.empty());
        }
    }

    private Mono<FetchResponse> toResponse(MessageManager mailbox, FetchData fetch, MailboxSession mailboxSession, FetchResponseBuilder builder, SelectedMailbox selected, MessageResult result) {
        try {
            return builder.build(fetch, result, mailbox, selected, mailboxSession);
        }
        catch (MessageRangeException e) {
            return ReactorUtils.logAsMono(() -> LOGGER.debug("Unable to find message with uid {}", (Object)result.getUid(), (Object)e)).then(Mono.empty());
        }
        catch (MailboxException e) {
            return ReactorUtils.logAsMono(() -> LOGGER.error("Unable to fetch message with uid {}, so skip it", (Object)result.getUid(), (Object)e)).then(Mono.empty());
        }
    }

    private Mono<Void> processMessageRange(SelectedMailbox selected, MessageManager mailbox, FetchData fetch, MailboxSession mailboxSession, ImapProcessor.Responder responder, FetchResponseBuilder builder, FetchGroup resultToFetch, MessageRange range) {
        return Flux.from((Publisher)mailbox.getMessagesReactive(range, resultToFetch, mailboxSession)).filter(ids -> !fetch.contains(FetchData.Item.MODSEQ) || ids.getModSeq().asLong() > fetch.getChangedSince()).concatMap(result -> this.toResponse(mailbox, fetch, mailboxSession, builder, selected, (MessageResult)result)).doOnNext(responder::respond).then();
    }

    @Override
    protected MDCBuilder mdc(FetchRequest request) {
        return MDCBuilder.create().addToContext("action", "FETCH").addToContext("useUid", Boolean.toString(request.isUseUids())).addToContext("idSet", IdRange.toString(request.getIdSet())).addToContext("fetchedData", request.getFetch().toString());
    }
}

