/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.routes;

import eu.timepit.refined.api.Refined;
import eu.timepit.refined.string;
import java.io.Serializable;
import java.util.Set;
import javax.inject.Inject;
import org.apache.james.jmap.core.CapabilityFactory;
import org.apache.james.jmap.core.ClientId;
import org.apache.james.jmap.core.ErrorCode$InvalidResultReference$;
import org.apache.james.jmap.core.ErrorCode$ServerFail$;
import org.apache.james.jmap.core.ErrorCode$UnknownMethod$;
import org.apache.james.jmap.core.Invocation;
import org.apache.james.jmap.core.Invocation$;
import org.apache.james.jmap.core.MissingCapabilityException;
import org.apache.james.jmap.core.RequestObject;
import org.apache.james.jmap.core.ResponseObject;
import org.apache.james.jmap.core.ResponseObject$;
import org.apache.james.jmap.core.ServerId;
import org.apache.james.jmap.method.InvocationWithContext;
import org.apache.james.jmap.method.Method;
import org.apache.james.jmap.routes.InvalidResultReferenceException;
import org.apache.james.jmap.routes.JMAPApi$;
import org.apache.james.jmap.routes.ProcessingContext;
import org.apache.james.jmap.routes.UnsupportedCapabilitiesException;
import org.apache.james.mailbox.MailboxSession;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import reactor.core.publisher.Flux;
import reactor.core.scala.publisher.SFlux;
import reactor.core.scala.publisher.SFlux$;
import reactor.core.scala.publisher.SFluxLike;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\u0005%v!B\t\u0013\u0011\u0003ib!B\u0010\u0013\u0011\u0003\u0001\u0003\"B\u0014\u0002\t\u0003A\u0003bB\u0015\u0002\u0005\u0004%\tA\u000b\u0005\u0007c\u0005\u0001\u000b\u0011B\u0016\u0007\t}\u0011\u0002A\r\u0005\tg\u0015\u0011\t\u0011)A\u0005i!AQ)\u0002B\u0001B\u0003%a\tC\u0003(\u000b\u0011\u0005!\fC\u0004_\u000b\t\u0007I\u0011B0\t\r),\u0001\u0015!\u0003a\u0011\u00159S\u0001\"\u0001l\u0011\u001d\tY!\u0002C\u0001\u0003\u001bAq!a\u0011\u0006\t\u0013\t)\u0005C\u0004\u0002\f\u0015!I!a\u001d\t\u000f\u0005\rU\u0001\"\u0003\u0002\u0006\"9\u0011QR\u0003\u0005\n\u0005=\u0015a\u0002&N\u0003B\u000b\u0005/\u001b\u0006\u0003'Q\taA]8vi\u0016\u001c(BA\u000b\u0017\u0003\u0011QW.\u00199\u000b\u0005]A\u0012!\u00026b[\u0016\u001c(BA\r\u001b\u0003\u0019\t\u0007/Y2iK*\t1$A\u0002pe\u001e\u001c\u0001\u0001\u0005\u0002\u001f\u00035\t!CA\u0004K\u001b\u0006\u0003\u0016\t]5\u0014\u0005\u0005\t\u0003C\u0001\u0012&\u001b\u0005\u0019#\"\u0001\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0019\u001a#AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002;\u00051AjT$H\u000bJ+\u0012a\u000b\t\u0003Y=j\u0011!\f\u0006\u0003]i\tQa\u001d7gi)L!\u0001M\u0017\u0003\r1{wmZ3s\u0003\u001daujR$F%\u0002\u001a\"!B\u0011\u0002\u000f5,G\u000f[8egB\u0019Q\u0007P \u000f\u0005YR\u0004CA\u001c$\u001b\u0005A$BA\u001d\u001d\u0003\u0019a$o\\8u}%\u00111hI\u0001\u0007!J,G-\u001a4\n\u0005ur$aA*fi*\u00111h\t\t\u0003\u0001\u000ek\u0011!\u0011\u0006\u0003\u0005R\ta!\\3uQ>$\u0017B\u0001#B\u0005\u0019iU\r\u001e5pI\u0006\u0019B-\u001a4bk2$8)\u00199bE&d\u0017\u000e^5fgB\u0019Q\u0007P$\u0011\u0005!;fBA%U\u001d\tQ%K\u0004\u0002L#:\u0011A\n\u0015\b\u0003\u001b>s!a\u000e(\n\u0003mI!!\u0007\u000e\n\u0005]A\u0012BA\u000b\u0017\u0013\t\u0019F#\u0001\u0003d_J,\u0017BA+W\u0003Q\u0019\u0015\r]1cS2LG/_%eK:$\u0018NZ5fe*\u00111\u000bF\u0005\u00031f\u0013AcQ1qC\nLG.\u001b;z\u0013\u0012,g\u000e^5gS\u0016\u0014(BA+W)\rYF,\u0018\t\u0003=\u0015AQa\r\u0005A\u0002QBQ!\u0012\u0005A\u0002\u0019\u000bQ\"\\3uQ>$7OQ=OC6,W#\u00011\u0011\tU\n7mP\u0005\u0003Ez\u00121!T1q!\t!wM\u0004\u0002JK&\u0011aMV\u0001\u000b\u0013:4xnY1uS>t\u0017B\u00015j\u0005)iU\r\u001e5pI:\u000bW.\u001a\u0006\u0003MZ\u000ba\"\\3uQ>$7OQ=OC6,\u0007\u0005F\u0002\\YVDQ!\\\u0006A\u00029\f1B[1wC6+G\u000f[8egB\u0019q\u000e^ \u000e\u0003AT!!\u001d:\u0002\tU$\u0018\u000e\u001c\u0006\u0002g\u0006!!.\u0019<b\u0013\ti\u0004\u000fC\u0003w\u0017\u0001\u0007q/A\u000btkB\u0004xN\u001d;fI\u000e\u000b\u0007/\u00192jY&$\u0018.Z:\u0011\u0007=$\b\u0010\u0005\u0002zu6\ta+\u0003\u0002|-\n\t2)\u00199bE&d\u0017\u000e^=GC\u000e$xN]=)\u0005-i\bc\u0001@\u0002\b5\tqP\u0003\u0003\u0002\u0002\u0005\r\u0011AB5oU\u0016\u001cGO\u0003\u0002\u0002\u0006\u0005)!.\u0019<bq&\u0019\u0011\u0011B@\u0003\r%s'.Z2u\u0003\u001d\u0001(o\\2fgN$b!a\u0004\u0002*\u0005M\u0002CBA\t\u0003?\t\u0019#\u0004\u0002\u0002\u0014)!\u0011QCA\f\u0003%\u0001XO\u00197jg\",'OC\u0002%\u00033Q1aUA\u000e\u0015\t\ti\"A\u0004sK\u0006\u001cGo\u001c:\n\t\u0005\u0005\u00121\u0003\u0002\u0006'6{gn\u001c\t\u0004s\u0006\u0015\u0012bAA\u0014-\nq!+Z:q_:\u001cXm\u00142kK\u000e$\bbBA\u0016\u0019\u0001\u0007\u0011QF\u0001\u000ee\u0016\fX/Z:u\u001f\nTWm\u0019;\u0011\u0007e\fy#C\u0002\u00022Y\u0013QBU3rk\u0016\u001cHo\u00142kK\u000e$\bbBA\u001b\u0019\u0001\u0007\u0011qG\u0001\u000f[\u0006LGNY8y'\u0016\u001c8/[8o!\u0011\tI$a\u0010\u000e\u0005\u0005m\"bAA\u001f-\u00059Q.Y5mE>D\u0018\u0002BA!\u0003w\u0011a\"T1jY\n|\u0007pU3tg&|g.A\u0012qe>\u001cWm]:TKF,XM\u001c;jC2d\u00170\u00118e+B$\u0017\r^3D_:$X\r\u001f;\u0015\u0015\u0005\u001d\u0013\u0011MA2\u0003K\ny\u0007\u0005\u0004\u0002\u0012\u0005}\u0011\u0011\n\t\u0007\u0003\u0017\n)&a\u0017\u000f\t\u00055\u0013\u0011\u000b\b\u0004o\u0005=\u0013\"\u0001\u0013\n\u0007\u0005M3%A\u0004qC\u000e\\\u0017mZ3\n\t\u0005]\u0013\u0011\f\u0002\u0004'\u0016\f(bAA*GA\u0019\u0001)!\u0018\n\u0007\u0005}\u0013IA\u000bJ]Z|7-\u0019;j_:<\u0016\u000e\u001e5D_:$X\r\u001f;\t\u000f\u0005-R\u00021\u0001\u0002.!9\u0011QG\u0007A\u0002\u0005]\u0002bBA4\u001b\u0001\u0007\u0011\u0011N\u0001\u0012aJ|7-Z:tS:<7i\u001c8uKb$\bc\u0001\u0010\u0002l%\u0019\u0011Q\u000e\n\u0003#A\u0013xnY3tg&twmQ8oi\u0016DH\u000f\u0003\u0004\u0002r5\u0001\rAR\u0001\rG\u0006\u0004\u0018MY5mSRLWm\u001d\u000b\t\u0003k\nY(! \u0002\u0000A1\u0011\u0011CA<\u00037JA!!\u001f\u0002\u0014\t)1K\u00127vq\"1\u0011\u0011\u000f\bA\u0002\u0019Cq!!\u000e\u000f\u0001\u0004\t9\u0004C\u0004\u0002\u0002:\u0001\r!a\u0017\u0002\u0015%tgo\\2bi&|g.\u0001\u000eqe>\u001cWm]:NKRDw\u000eZ,ji\"l\u0015\r^2i\u001d\u0006lW\r\u0006\u0005\u0002v\u0005\u001d\u0015\u0011RAF\u0011\u0019\t\th\u0004a\u0001\r\"9\u0011\u0011Q\bA\u0002\u0005m\u0003bBA\u001b\u001f\u0001\u0007\u0011qG\u0001\u0015m\u0006d\u0017\u000eZ1uK\u000e\u000b\u0007/\u00192jY&$\u0018.Z:\u0015\r\u0005E\u00151UAS!!\tY%a%\u0002\u0018\u0006u\u0015\u0002BAK\u00033\u0012a!R5uQ\u0016\u0014\bcA=\u0002\u001a&\u0019\u00111\u0014,\u000355K7o]5oO\u000e\u000b\u0007/\u00192jY&$\u00180\u0012=dKB$\u0018n\u001c8\u0011\u0007\t\ny*C\u0002\u0002\"\u000e\u0012A!\u00168ji\"1\u0011\u0011\u000f\tA\u0002\u0019Ca!a*\u0011\u0001\u00041\u0015\u0001\u0006:fcVL'/\u001a3DCB\f'-\u001b7ji&,7\u000f")
public class JMAPApi {
    private final scala.collection.immutable.Set<Refined<String, string.Uri>> defaultCapabilities;
    private final Map<Invocation.MethodName, Method> methodsByName;

    public static Logger LOGGER() {
        return JMAPApi$.MODULE$.LOGGER();
    }

    private Map<Invocation.MethodName, Method> methodsByName() {
        return this.methodsByName;
    }

    public SMono<ResponseObject> process(RequestObject requestObject, MailboxSession mailboxSession) {
        ProcessingContext processingContext = new ProcessingContext((Map<ClientId, ServerId>)Predef$.MODULE$.Map().empty(), (Map<Invocation.MethodCallId, Invocation>)Predef$.MODULE$.Map().empty());
        scala.collection.immutable.Set unsupportedCapabilities = (scala.collection.immutable.Set)requestObject.using().$minus$minus(this.defaultCapabilities);
        scala.collection.immutable.Set<Refined<String, string.Uri>> capabilities = requestObject.using();
        if (unsupportedCapabilities.nonEmpty()) {
            return SMono$.MODULE$.error((Throwable)new UnsupportedCapabilitiesException((scala.collection.immutable.Set<Refined<String, string.Uri>>)unsupportedCapabilities));
        }
        return this.processSequentiallyAndUpdateContext(requestObject, mailboxSession, processingContext, capabilities).map((Function1 & Serializable)invocations -> new ResponseObject(ResponseObject$.MODULE$.SESSION_STATE(), (Seq<Invocation>)((Seq)invocations.map((Function1 & Serializable)x$1 -> x$1.invocation()))));
    }

    private SMono<Seq<InvocationWithContext>> processSequentiallyAndUpdateContext(RequestObject requestObject, MailboxSession mailboxSession, ProcessingContext processingContext, scala.collection.immutable.Set<Refined<String, string.Uri>> capabilities) {
        return SFlux$.MODULE$.fromIterable(requestObject.methodCalls()).fold((Object)Nil$.MODULE$, (Function2 & Serializable)(acc, elem) -> {
            SMono lastProcessingContext = (SMono)acc.headOption().map((Function1 & Serializable)last -> SMono$.MODULE$.fromPublisher((Publisher)Flux.from((Publisher)last.map((Function1 & Serializable)x$2 -> x$2.processingContext())).last())).getOrElse((Function0 & Serializable)() -> SMono$.MODULE$.just((Object)processingContext));
            SFlux invocation = lastProcessingContext.flatMapMany((Function1 & Serializable)context -> this.process(capabilities, mailboxSession, new InvocationWithContext((Invocation)elem, (ProcessingContext)context)));
            SFlux sFlux = invocation.cache(invocation.cache$default$1(), invocation.cache$default$2());
            return acc.$colon$colon((Object)sFlux);
        }).map((Function1 & Serializable)x$3 -> x$3.reverse()).flatMap((Function1 & Serializable)list -> {
            SFlux qual$1 = SFlux$.MODULE$.fromIterable((Iterable)list);
            Function1 & Serializable x$1 = (Function1 & Serializable)e -> e;
            int x$2 = qual$1.concatMap$default$2();
            return qual$1.concatMap((Function1)x$1, x$2).collectSeq();
        });
    }

    private SFlux<InvocationWithContext> process(scala.collection.immutable.Set<Refined<String, string.Uri>> capabilities, MailboxSession mailboxSession, InvocationWithContext invocation) {
        SFlux sFlux;
        Either<InvalidResultReferenceException, Invocation> either = invocation.processingContext().resolveBackReferences(invocation.invocation());
        if (either instanceof Left) {
            Left left = (Left)either;
            InvalidResultReferenceException e = (InvalidResultReferenceException)left.value();
            sFlux = SFlux$.MODULE$.just((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new InvocationWithContext[]{new InvocationWithContext(Invocation$.MODULE$.error(ErrorCode$InvalidResultReference$.MODULE$, new StringBuilder(33).append("Failed resolving back-reference: ").append(e.message()).toString(), invocation.invocation().methodCallId()), invocation.processingContext())}));
        } else if (either instanceof Right) {
            Right right = (Right)either;
            Invocation resolvedInvocation = (Invocation)right.value();
            sFlux = this.processMethodWithMatchName(capabilities, new InvocationWithContext(resolvedInvocation, invocation.processingContext()), mailboxSession).map((Function1 & Serializable)x$4 -> x$4.recordInvocation());
        } else {
            throw new MatchError(either);
        }
        return SFlux$.MODULE$.fromPublisher((Publisher)sFlux);
    }

    private SFlux<InvocationWithContext> processMethodWithMatchName(scala.collection.immutable.Set<Refined<String, string.Uri>> capabilities, InvocationWithContext invocation, MailboxSession mailboxSession) {
        return ((SFluxLike)this.methodsByName().get((Object)invocation.invocation().methodName()).map((Function1 & Serializable)method -> (SFlux)this.validateCapabilities(capabilities, method.requiredCapabilities()).fold((Function1 & Serializable)e -> SFlux$.MODULE$.just((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new InvocationWithContext[]{new InvocationWithContext(Invocation$.MODULE$.error(ErrorCode$UnknownMethod$.MODULE$, e.description(), invocation.invocation().methodCallId()), invocation.processingContext())})), (Function1 & Serializable)x$5 -> SFlux$.MODULE$.fromPublisher(method.process(capabilities, invocation, mailboxSession)))).getOrElse((Function0 & Serializable)() -> SFlux$.MODULE$.just((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new InvocationWithContext[]{new InvocationWithContext(Invocation$.MODULE$.error(ErrorCode$UnknownMethod$.MODULE$, invocation.invocation().methodCallId()), invocation.processingContext())})))).onErrorResume((Function1 & Serializable)throwable -> SMono$.MODULE$.just((Object)new InvocationWithContext(Invocation$.MODULE$.error(ErrorCode$ServerFail$.MODULE$, throwable.getMessage(), invocation.invocation().methodCallId()), invocation.processingContext())));
    }

    private Either<MissingCapabilityException, BoxedUnit> validateCapabilities(scala.collection.immutable.Set<Refined<String, string.Uri>> capabilities, scala.collection.immutable.Set<Refined<String, string.Uri>> requiredCapabilities) {
        scala.collection.immutable.Set missingCapabilities = (scala.collection.immutable.Set)requiredCapabilities.$minus$minus(capabilities);
        if (missingCapabilities.nonEmpty()) {
            return package$.MODULE$.Left().apply((Object)new MissingCapabilityException(new StringBuilder(25).append("Missing capability(ies): ").append(missingCapabilities.mkString(", ")).toString()));
        }
        return package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
    }

    public JMAPApi(scala.collection.immutable.Set<Method> methods, scala.collection.immutable.Set<Refined<String, string.Uri>> defaultCapabilities) {
        this.defaultCapabilities = defaultCapabilities;
        this.methodsByName = ((IterableOnceOps)methods.map((Function1 & Serializable)method -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)method.methodName()), method))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    @Inject
    public JMAPApi(Set<Method> javaMethods, Set<CapabilityFactory> supportedCapabilities) {
        this((scala.collection.immutable.Set<Method>)CollectionConverters$.MODULE$.SetHasAsScala(javaMethods).asScala().toSet(), (scala.collection.immutable.Set<Refined<String, string.Uri>>)((IterableOnceOps)CollectionConverters$.MODULE$.SetHasAsScala(supportedCapabilities).asScala().map((Function1)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final String apply(CapabilityFactory x) {
                return x.id();
            }
        })).toSet());
    }
}

